"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notebookSavedObject = void 0;
var _shared = require("../../common/constants/shared");
var _observability_saved_object_attributes = require("../../common/types/observability_saved_object_attributes");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const notebookSavedObject = exports.notebookSavedObject = {
  name: _observability_saved_object_attributes.NOTEBOOK_SAVED_OBJECT,
  hidden: false,
  namespaceType: 'single',
  management: {
    defaultSearchField: 'title',
    importableAndExportable: true,
    icon: 'notebookApp',
    getTitle(obj) {
      return obj.attributes.title;
    },
    getInAppUrl(obj) {
      const editUrl = `/app/${_shared.investigationNotebookID}#/${obj.id}?view=view_both`;
      return {
        path: editUrl,
        uiCapabilitiesPath: 'observability.show'
      };
    }
  },
  mappings: {
    dynamic: false,
    properties: {
      title: {
        type: 'text'
      },
      description: {
        type: 'text'
      },
      version: {
        type: 'integer'
      }
    }
  },
  migrations: {}
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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