"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleError = exports.getOpenSearchClientTransport = void 0;
var _opensearch = require("@opensearch-project/opensearch");
var _get_set = require("../services/get_set");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const getOpenSearchClientTransport = async ({
  context,
  dataSourceId,
  request // eslint-disable-line
}) => {
  if (dataSourceId && context.dataSource) {
    return (await context.dataSource.opensearch.getClient(dataSourceId)).transport;
  }
  return context.core.opensearch.client.asCurrentUser.transport;
};
exports.getOpenSearchClientTransport = getOpenSearchClientTransport;
const handleError = (e, res, logger = (0, _get_set.getLogger)()) => {
  logger.error(`Investigation error happens: ${e.body || e.message}`);
  // handle OpenSearch client connection errors
  if (e instanceof _opensearch.errors.NoLivingConnectionsError || e instanceof _opensearch.errors.ConnectionError) {
    return res.customError({
      body: e.message,
      statusCode: 400
    });
  }

  // handle http response error of calling backend API
  if (e.statusCode >= 400) {
    return res.customError({
      body: {
        message: 'Unable to process the request, please try again later.'
      },
      statusCode: e.statusCode
    });
  }

  // Return an general internalError for unhandled server-side issues
  return res.internalError();
};
exports.handleError = handleError;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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