"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerLogPatternRoute = registerLogPatternRoute;
var _configSchema = require("@osd/config-schema");
var _notebooks = require("../../../common/constants/notebooks");
var _utils = require("../utils");
var _get_set = require("../../services/get_set");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerLogPatternRoute(router) {
  router.post({
    path: `${_notebooks.NOTEBOOKS_API_PREFIX}/logpattern/analyze`,
    validate: {
      body: _configSchema.schema.object({
        baselineStartTime: _configSchema.schema.maybe(_configSchema.schema.string()),
        baselineEndTime: _configSchema.schema.maybe(_configSchema.schema.string()),
        selectionStartTime: _configSchema.schema.string(),
        selectionEndTime: _configSchema.schema.string(),
        timeField: _configSchema.schema.string(),
        traceIdField: _configSchema.schema.maybe(_configSchema.schema.string()),
        logMessageField: _configSchema.schema.string(),
        indexName: _configSchema.schema.string(),
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    try {
      const transport = await (0, _utils.getOpenSearchClientTransport)({
        context,
        dataSourceId: request.body.dataSourceMDSId,
        request
      });
      const body = await (0, _get_set.getMLService)().analyzeLogPattern({
        transport,
        parameters: {
          baseTimeRangeStart: request.body.baselineStartTime,
          baseTimeRangeEnd: request.body.baselineEndTime,
          selectionTimeRangeStart: request.body.selectionStartTime,
          selectionTimeRangeEnd: request.body.selectionEndTime,
          traceFieldName: request.body.traceIdField,
          timeField: request.body.timeField,
          logFieldName: request.body.logMessageField,
          index: request.body.indexName
        }
      });
      const convertMapToSequenceArray = map => {
        if (!map) return [];
        return Object.entries(map).map(([traceId, sequence]) => ({
          traceId,
          sequence
        }));
      };
      const result = JSON.parse(body.inference_results[0].output[0].result);
      return response.ok({
        body: {
          ...result,
          EXCEPTIONAL: convertMapToSequenceArray(result.EXCEPTIONAL),
          BASE: convertMapToSequenceArray(result.BASE)
        }
      });
    } catch (error) {
      return (0, _utils.handleError)(error, response);
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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