"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupRoutes = setupRoutes;
var _notebook_router = require("./notebooks/notebook_router");
var _paragraph_router = require("./notebooks/paragraph_router");
var _log_pattern_router = require("./notebooks/log_pattern_router");
var _hypothesis_router = require("./notebooks/hypothesis_router");
var _ml_router = require("./notebooks/ml_router");
var _agent_router = require("./notebooks/agent_router");
var _visualization_summary = require("./notebooks/visualization_summary");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function setupRoutes({
  router,
  auth
}) {
  // notebooks routes
  (0, _paragraph_router.registerParaRoute)(router);
  (0, _notebook_router.registerNoteRoute)(router, auth);
  (0, _log_pattern_router.registerLogPatternRoute)(router);
  (0, _hypothesis_router.registerHypothesisRoute)(router);
  (0, _ml_router.registerMLConnectorRoute)(router);
  (0, _agent_router.registerAgentExecutionRoute)(router);
  (0, _visualization_summary.registerVisualizationSummaryRoute)(router);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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