"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationPlugin = void 0;
var _std = require("@osd/std");
var _index = require("./routes/index");
var _observability_saved_object = require("./saved_objects/observability_saved_object");
var _get_set = require("./services/get_set");
var _query_service = require("./services/query_service");
var _ml_service = require("./services/ml_service");
var _base_service = require("./services/base_service");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class InvestigationPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "config$", void 0);
    this.logger = initializerContext.logger.get();
    this.config$ = initializerContext.config.create();
  }
  async setup(core) {
    this.logger.debug('Observability: Setup');
    const router = core.http.createRouter();
    const auth = core.http.auth;
    const config = await (0, _std.firstValueFrom)(this.config$);
    const baseService = new _base_service.BaseService(core, this.logger);
    core.capabilities.registerProvider(() => {
      return {
        investigation: {
          ...config,
          ownerSupported: false
        }
      };
    });
    core.capabilities.registerSwitcher(baseService.capabilitiesSwitcher);
    (0, _get_set.setQueryService)(new _query_service.QueryService(this.logger));
    (0, _get_set.setMLService)(new _ml_service.MLService());
    (0, _get_set.setLogger)(this.logger);

    // Register server side APIs
    (0, _index.setupRoutes)({
      router,
      auth
    });
    core.savedObjects.registerType(_observability_saved_object.notebookSavedObject);
    return {};
  }
  start(_core) {
    this.logger.debug('Observability: Started');
    (0, _get_set.setCapabilities)(_core.capabilities);
    return {};
  }
  stop() {}
}
exports.InvestigationPlugin = InvestigationPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfc3RkIiwicmVxdWlyZSIsIl9pbmRleCIsIl9vYnNlcnZhYmlsaXR5X3NhdmVkX29iamVjdCIsIl9nZXRfc2V0IiwiX3F1ZXJ5X3NlcnZpY2UiLCJfbWxfc2VydmljZSIsIl9iYXNlX3NlcnZpY2UiLCJfZGVmaW5lUHJvcGVydHkiLCJlIiwiciIsInQiLCJfdG9Qcm9wZXJ0eUtleSIsIk9iamVjdCIsImRlZmluZVByb3BlcnR5IiwidmFsdWUiLCJlbnVtZXJhYmxlIiwiY29uZmlndXJhYmxlIiwid3JpdGFibGUiLCJpIiwiX3RvUHJpbWl0aXZlIiwiU3ltYm9sIiwidG9QcmltaXRpdmUiLCJjYWxsIiwiVHlwZUVycm9yIiwiU3RyaW5nIiwiTnVtYmVyIiwiSW52ZXN0aWdhdGlvblBsdWdpbiIsImNvbnN0cnVjdG9yIiwiaW5pdGlhbGl6ZXJDb250ZXh0IiwibG9nZ2VyIiwiZ2V0IiwiY29uZmlnJCIsImNvbmZpZyIsImNyZWF0ZSIsInNldHVwIiwiY29yZSIsImRlYnVnIiwicm91dGVyIiwiaHR0cCIsImNyZWF0ZVJvdXRlciIsImF1dGgiLCJmaXJzdFZhbHVlRnJvbSIsImJhc2VTZXJ2aWNlIiwiQmFzZVNlcnZpY2UiLCJjYXBhYmlsaXRpZXMiLCJyZWdpc3RlclByb3ZpZGVyIiwiaW52ZXN0aWdhdGlvbiIsIm93bmVyU3VwcG9ydGVkIiwicmVnaXN0ZXJTd2l0Y2hlciIsImNhcGFiaWxpdGllc1N3aXRjaGVyIiwic2V0UXVlcnlTZXJ2aWNlIiwiUXVlcnlTZXJ2aWNlIiwic2V0TUxTZXJ2aWNlIiwiTUxTZXJ2aWNlIiwic2V0TG9nZ2VyIiwic2V0dXBSb3V0ZXMiLCJzYXZlZE9iamVjdHMiLCJyZWdpc3RlclR5cGUiLCJub3RlYm9va1NhdmVkT2JqZWN0Iiwic3RhcnQiLCJfY29yZSIsInNldENhcGFiaWxpdGllcyIsInN0b3AiLCJleHBvcnRzIl0sInNvdXJjZXMiOlsicGx1Z2luLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXHJcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xyXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxyXG4gKi9cclxuXHJcbmltcG9ydCB7IEludmVzdGlnYXRpb25Db25maWcgfSBmcm9tICdzZXJ2ZXInO1xyXG5pbXBvcnQgeyBPYnNlcnZhYmxlIH0gZnJvbSAncnhqcyc7XHJcbmltcG9ydCB7IGZpcnN0VmFsdWVGcm9tIH0gZnJvbSAnQG9zZC9zdGQnO1xyXG5pbXBvcnQge1xyXG4gIENvcmVTZXR1cCxcclxuICBDb3JlU3RhcnQsXHJcbiAgTG9nZ2VyLFxyXG4gIFBsdWdpbixcclxuICBQbHVnaW5Jbml0aWFsaXplckNvbnRleHQsXHJcbn0gZnJvbSAnLi4vLi4vLi4vc3JjL2NvcmUvc2VydmVyJztcclxuaW1wb3J0IHsgc2V0dXBSb3V0ZXMgfSBmcm9tICcuL3JvdXRlcy9pbmRleCc7XHJcbmltcG9ydCB7IG5vdGVib29rU2F2ZWRPYmplY3QgfSBmcm9tICcuL3NhdmVkX29iamVjdHMvb2JzZXJ2YWJpbGl0eV9zYXZlZF9vYmplY3QnO1xyXG5pbXBvcnQgeyBzZXRDYXBhYmlsaXRpZXMsIHNldExvZ2dlciwgc2V0TUxTZXJ2aWNlLCBzZXRRdWVyeVNlcnZpY2UgfSBmcm9tICcuL3NlcnZpY2VzL2dldF9zZXQnO1xyXG5pbXBvcnQgeyBRdWVyeVNlcnZpY2UgfSBmcm9tICcuL3NlcnZpY2VzL3F1ZXJ5X3NlcnZpY2UnO1xyXG5pbXBvcnQgeyBNTFNlcnZpY2UgfSBmcm9tICcuL3NlcnZpY2VzL21sX3NlcnZpY2UnO1xyXG5pbXBvcnQgeyBJbnZlc3RpZ2F0aW9uUGx1Z2luU2V0dXAsIEludmVzdGlnYXRpb25QbHVnaW5TdGFydCB9IGZyb20gJy4vdHlwZXMnO1xyXG5pbXBvcnQgeyBCYXNlU2VydmljZSB9IGZyb20gJy4vc2VydmljZXMvYmFzZV9zZXJ2aWNlJztcclxuXHJcbmV4cG9ydCBjbGFzcyBJbnZlc3RpZ2F0aW9uUGx1Z2luXHJcbiAgaW1wbGVtZW50cyBQbHVnaW48SW52ZXN0aWdhdGlvblBsdWdpblNldHVwLCBJbnZlc3RpZ2F0aW9uUGx1Z2luU3RhcnQ+IHtcclxuICBwcml2YXRlIHJlYWRvbmx5IGxvZ2dlcjogTG9nZ2VyO1xyXG4gIHByaXZhdGUgcmVhZG9ubHkgY29uZmlnJDogT2JzZXJ2YWJsZTxJbnZlc3RpZ2F0aW9uQ29uZmlnPjtcclxuXHJcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBpbml0aWFsaXplckNvbnRleHQ6IFBsdWdpbkluaXRpYWxpemVyQ29udGV4dCkge1xyXG4gICAgdGhpcy5sb2dnZXIgPSBpbml0aWFsaXplckNvbnRleHQubG9nZ2VyLmdldCgpO1xyXG4gICAgdGhpcy5jb25maWckID0gaW5pdGlhbGl6ZXJDb250ZXh0LmNvbmZpZy5jcmVhdGU8SW52ZXN0aWdhdGlvbkNvbmZpZz4oKTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBhc3luYyBzZXR1cChjb3JlOiBDb3JlU2V0dXApIHtcclxuICAgIHRoaXMubG9nZ2VyLmRlYnVnKCdPYnNlcnZhYmlsaXR5OiBTZXR1cCcpO1xyXG4gICAgY29uc3Qgcm91dGVyID0gY29yZS5odHRwLmNyZWF0ZVJvdXRlcigpO1xyXG4gICAgY29uc3QgYXV0aCA9IGNvcmUuaHR0cC5hdXRoO1xyXG4gICAgY29uc3QgY29uZmlnID0gYXdhaXQgZmlyc3RWYWx1ZUZyb20odGhpcy5jb25maWckKTtcclxuICAgIGNvbnN0IGJhc2VTZXJ2aWNlID0gbmV3IEJhc2VTZXJ2aWNlKGNvcmUsIHRoaXMubG9nZ2VyKTtcclxuICAgIGNvcmUuY2FwYWJpbGl0aWVzLnJlZ2lzdGVyUHJvdmlkZXIoKCkgPT4ge1xyXG4gICAgICByZXR1cm4ge1xyXG4gICAgICAgIGludmVzdGlnYXRpb246IHtcclxuICAgICAgICAgIC4uLmNvbmZpZyxcclxuICAgICAgICAgIG93bmVyU3VwcG9ydGVkOiBmYWxzZSxcclxuICAgICAgICB9LFxyXG4gICAgICB9O1xyXG4gICAgfSk7XHJcblxyXG4gICAgY29yZS5jYXBhYmlsaXRpZXMucmVnaXN0ZXJTd2l0Y2hlcihiYXNlU2VydmljZS5jYXBhYmlsaXRpZXNTd2l0Y2hlcik7XHJcblxyXG4gICAgc2V0UXVlcnlTZXJ2aWNlKG5ldyBRdWVyeVNlcnZpY2UodGhpcy5sb2dnZXIpKTtcclxuICAgIHNldE1MU2VydmljZShuZXcgTUxTZXJ2aWNlKCkpO1xyXG4gICAgc2V0TG9nZ2VyKHRoaXMubG9nZ2VyKTtcclxuXHJcbiAgICAvLyBSZWdpc3RlciBzZXJ2ZXIgc2lkZSBBUElzXHJcbiAgICBzZXR1cFJvdXRlcyh7XHJcbiAgICAgIHJvdXRlcixcclxuICAgICAgYXV0aCxcclxuICAgIH0pO1xyXG5cclxuICAgIGNvcmUuc2F2ZWRPYmplY3RzLnJlZ2lzdGVyVHlwZShub3RlYm9va1NhdmVkT2JqZWN0KTtcclxuXHJcbiAgICByZXR1cm4ge307XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc3RhcnQoX2NvcmU6IENvcmVTdGFydCkge1xyXG4gICAgdGhpcy5sb2dnZXIuZGVidWcoJ09ic2VydmFiaWxpdHk6IFN0YXJ0ZWQnKTtcclxuXHJcbiAgICBzZXRDYXBhYmlsaXRpZXMoX2NvcmUuY2FwYWJpbGl0aWVzKTtcclxuXHJcbiAgICByZXR1cm4ge307XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc3RvcCgpIHt9XHJcbn1cclxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFPQSxJQUFBQSxJQUFBLEdBQUFDLE9BQUE7QUFRQSxJQUFBQyxNQUFBLEdBQUFELE9BQUE7QUFDQSxJQUFBRSwyQkFBQSxHQUFBRixPQUFBO0FBQ0EsSUFBQUcsUUFBQSxHQUFBSCxPQUFBO0FBQ0EsSUFBQUksY0FBQSxHQUFBSixPQUFBO0FBQ0EsSUFBQUssV0FBQSxHQUFBTCxPQUFBO0FBRUEsSUFBQU0sYUFBQSxHQUFBTixPQUFBO0FBQXNELFNBQUFPLGdCQUFBQyxDQUFBLEVBQUFDLENBQUEsRUFBQUMsQ0FBQSxZQUFBRCxDQUFBLEdBQUFFLGNBQUEsQ0FBQUYsQ0FBQSxNQUFBRCxDQUFBLEdBQUFJLE1BQUEsQ0FBQUMsY0FBQSxDQUFBTCxDQUFBLEVBQUFDLENBQUEsSUFBQUssS0FBQSxFQUFBSixDQUFBLEVBQUFLLFVBQUEsTUFBQUMsWUFBQSxNQUFBQyxRQUFBLFVBQUFULENBQUEsQ0FBQUMsQ0FBQSxJQUFBQyxDQUFBLEVBQUFGLENBQUE7QUFBQSxTQUFBRyxlQUFBRCxDQUFBLFFBQUFRLENBQUEsR0FBQUMsWUFBQSxDQUFBVCxDQUFBLHVDQUFBUSxDQUFBLEdBQUFBLENBQUEsR0FBQUEsQ0FBQTtBQUFBLFNBQUFDLGFBQUFULENBQUEsRUFBQUQsQ0FBQSwyQkFBQUMsQ0FBQSxLQUFBQSxDQUFBLFNBQUFBLENBQUEsTUFBQUYsQ0FBQSxHQUFBRSxDQUFBLENBQUFVLE1BQUEsQ0FBQUMsV0FBQSxrQkFBQWIsQ0FBQSxRQUFBVSxDQUFBLEdBQUFWLENBQUEsQ0FBQWMsSUFBQSxDQUFBWixDQUFBLEVBQUFELENBQUEsdUNBQUFTLENBQUEsU0FBQUEsQ0FBQSxZQUFBSyxTQUFBLHlFQUFBZCxDQUFBLEdBQUFlLE1BQUEsR0FBQUMsTUFBQSxFQUFBZixDQUFBLEtBckJ0RDtBQUNBO0FBQ0E7QUFDQTtBQW9CTyxNQUFNZ0IsbUJBQW1CLENBQ3dDO0VBSXRFQyxXQUFXQSxDQUFrQkMsa0JBQTRDLEVBQUU7SUFBQSxLQUE5Q0Esa0JBQTRDLEdBQTVDQSxrQkFBNEM7SUFBQXJCLGVBQUE7SUFBQUEsZUFBQTtJQUN2RSxJQUFJLENBQUNzQixNQUFNLEdBQUdELGtCQUFrQixDQUFDQyxNQUFNLENBQUNDLEdBQUcsQ0FBQyxDQUFDO0lBQzdDLElBQUksQ0FBQ0MsT0FBTyxHQUFHSCxrQkFBa0IsQ0FBQ0ksTUFBTSxDQUFDQyxNQUFNLENBQXNCLENBQUM7RUFDeEU7RUFFQSxNQUFhQyxLQUFLQSxDQUFDQyxJQUFlLEVBQUU7SUFDbEMsSUFBSSxDQUFDTixNQUFNLENBQUNPLEtBQUssQ0FBQyxzQkFBc0IsQ0FBQztJQUN6QyxNQUFNQyxNQUFNLEdBQUdGLElBQUksQ0FBQ0csSUFBSSxDQUFDQyxZQUFZLENBQUMsQ0FBQztJQUN2QyxNQUFNQyxJQUFJLEdBQUdMLElBQUksQ0FBQ0csSUFBSSxDQUFDRSxJQUFJO0lBQzNCLE1BQU1SLE1BQU0sR0FBRyxNQUFNLElBQUFTLG1CQUFjLEVBQUMsSUFBSSxDQUFDVixPQUFPLENBQUM7SUFDakQsTUFBTVcsV0FBVyxHQUFHLElBQUlDLHlCQUFXLENBQUNSLElBQUksRUFBRSxJQUFJLENBQUNOLE1BQU0sQ0FBQztJQUN0RE0sSUFBSSxDQUFDUyxZQUFZLENBQUNDLGdCQUFnQixDQUFDLE1BQU07TUFDdkMsT0FBTztRQUNMQyxhQUFhLEVBQUU7VUFDYixHQUFHZCxNQUFNO1VBQ1RlLGNBQWMsRUFBRTtRQUNsQjtNQUNGLENBQUM7SUFDSCxDQUFDLENBQUM7SUFFRlosSUFBSSxDQUFDUyxZQUFZLENBQUNJLGdCQUFnQixDQUFDTixXQUFXLENBQUNPLG9CQUFvQixDQUFDO0lBRXBFLElBQUFDLHdCQUFlLEVBQUMsSUFBSUMsMkJBQVksQ0FBQyxJQUFJLENBQUN0QixNQUFNLENBQUMsQ0FBQztJQUM5QyxJQUFBdUIscUJBQVksRUFBQyxJQUFJQyxxQkFBUyxDQUFDLENBQUMsQ0FBQztJQUM3QixJQUFBQyxrQkFBUyxFQUFDLElBQUksQ0FBQ3pCLE1BQU0sQ0FBQzs7SUFFdEI7SUFDQSxJQUFBMEIsa0JBQVcsRUFBQztNQUNWbEIsTUFBTTtNQUNORztJQUNGLENBQUMsQ0FBQztJQUVGTCxJQUFJLENBQUNxQixZQUFZLENBQUNDLFlBQVksQ0FBQ0MsK0NBQW1CLENBQUM7SUFFbkQsT0FBTyxDQUFDLENBQUM7RUFDWDtFQUVPQyxLQUFLQSxDQUFDQyxLQUFnQixFQUFFO0lBQzdCLElBQUksQ0FBQy9CLE1BQU0sQ0FBQ08sS0FBSyxDQUFDLHdCQUF3QixDQUFDO0lBRTNDLElBQUF5Qix3QkFBZSxFQUFDRCxLQUFLLENBQUNoQixZQUFZLENBQUM7SUFFbkMsT0FBTyxDQUFDLENBQUM7RUFDWDtFQUVPa0IsSUFBSUEsQ0FBQSxFQUFHLENBQUM7QUFDakI7QUFBQ0MsT0FBQSxDQUFBckMsbUJBQUEsR0FBQUEsbUJBQUEifQ==