"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "InvestigationPluginSetup", {
  enumerable: true,
  get: function () {
    return _types.InvestigationPluginSetup;
  }
});
Object.defineProperty(exports, "InvestigationPluginStart", {
  enumerable: true,
  get: function () {
    return _types.InvestigationPluginStart;
  }
});
exports.config = void 0;
exports.plugin = plugin;
var _configSchema = require("@osd/config-schema");
var _plugin = require("./plugin");
var _types = require("./types");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function plugin(initializerContext) {
  return new _plugin.InvestigationPlugin(initializerContext);
}
const investigationConfig = {
  schema: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    }),
    agenticFeaturesEnabled: _configSchema.schema.boolean({
      defaultValue: false
    })
  })
};
const config = exports.config = {
  schema: investigationConfig.schema
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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