"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateFieldContext = void 0;
var _lodash = require("lodash");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * @template T = unknown - mapping Context
 * @template U = unknown - search Context
 * @param mappings - mapping from get mappings request
 * @param hits - search response that contains a sample document
 * @returns a string that describes fields, types, and sample values
 */
const generateFieldContext = (mappings, hits) => {
  var _hits$body$hits$hits$;
  const flattenedFields = flattenMappings(mappings);
  const source = (_hits$body$hits$hits$ = hits.body.hits.hits[0]) === null || _hits$body$hits$hits$ === void 0 ? void 0 : _hits$body$hits$hits$._source;
  return Object.entries(flattenedFields).filter(([, type]) => type !== 'alias') // PPL doesn't support 'alias' type
  .map(([field, type]) => {
    return `- ${field}: ${type} (${extractValue(source, field, type)})`;
  }).join('\n');
};
exports.generateFieldContext = generateFieldContext;
const extractValue = (source, field, type) => {
  const value = (0, _lodash.get)(source, field);
  if (value === undefined) return null;
  if (['text', 'keyword'].includes(type)) return `"${value}"`;
  return value;
};

/**
 * Flatten mappings response to an object of fields and types.
 *
 * @template T = unknown - Context
 * @param mappings - mapping from get mappings request
 * @returns an object of fields and types
 */
const flattenMappings = mappings => {
  const fields = {};
  Object.values(mappings.body).forEach(body => parseProperties(body.mappings.properties, undefined, fields));
  return fields;
};
const parseProperties = (properties, prefixes = [], fields) => {
  Object.entries(properties || {}).forEach(([key, value]) => {
    if (value.properties) {
      parseProperties(value.properties, [...prefixes, key], fields);
    } else {
      fields[[...prefixes, key].join('.')] = value.type;
    }
  });
  return fields;
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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