"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requestor = void 0;
var _wreck = _interopRequireDefault(require("@hapi/wreck"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const requestor = async function (requestType, url, wreckOptions) {
  const promise = _wreck.default.request(requestType, url, wreckOptions);
  const res = await promise;
  const body = await _wreck.default.read(res, wreckOptions);
  return body;
};
exports.requestor = requestor;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfd3JlY2siLCJfaW50ZXJvcFJlcXVpcmVEZWZhdWx0IiwicmVxdWlyZSIsImUiLCJfX2VzTW9kdWxlIiwiZGVmYXVsdCIsInJlcXVlc3RvciIsInJlcXVlc3RUeXBlIiwidXJsIiwid3JlY2tPcHRpb25zIiwicHJvbWlzZSIsIldyZWNrIiwicmVxdWVzdCIsInJlcyIsImJvZHkiLCJyZWFkIiwiZXhwb3J0cyJdLCJzb3VyY2VzIjpbIndyZWNrX3JlcXVlc3RzLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXHJcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xyXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxyXG4gKi9cclxuXHJcbmltcG9ydCBXcmVjayBmcm9tICdAaGFwaS93cmVjayc7XHJcbmltcG9ydCB7IE9wdGlvbnNUeXBlIH0gZnJvbSAnLi4vLi4vLi4vLi4vY29tbW9uL3R5cGVzL25vdGVib29rcyc7XHJcblxyXG5leHBvcnQgY29uc3QgcmVxdWVzdG9yID0gYXN5bmMgZnVuY3Rpb24gKFxyXG4gIHJlcXVlc3RUeXBlOiBzdHJpbmcsXHJcbiAgdXJsOiBzdHJpbmcsXHJcbiAgd3JlY2tPcHRpb25zOiBPcHRpb25zVHlwZVxyXG4pIHtcclxuICBjb25zdCBwcm9taXNlID0gV3JlY2sucmVxdWVzdChyZXF1ZXN0VHlwZSwgdXJsLCB3cmVja09wdGlvbnMpO1xyXG4gIGNvbnN0IHJlcyA9IGF3YWl0IHByb21pc2U7XHJcbiAgY29uc3QgYm9keSA9IGF3YWl0IFdyZWNrLnJlYWQocmVzLCB3cmVja09wdGlvbnMpO1xyXG4gIHJldHVybiBib2R5O1xyXG59O1xyXG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUtBLElBQUFBLE1BQUEsR0FBQUMsc0JBQUEsQ0FBQUMsT0FBQTtBQUFnQyxTQUFBRCx1QkFBQUUsQ0FBQSxXQUFBQSxDQUFBLElBQUFBLENBQUEsQ0FBQUMsVUFBQSxHQUFBRCxDQUFBLEtBQUFFLE9BQUEsRUFBQUYsQ0FBQTtBQUxoQztBQUNBO0FBQ0E7QUFDQTs7QUFLTyxNQUFNRyxTQUFTLEdBQUcsZUFBQUEsQ0FDdkJDLFdBQW1CLEVBQ25CQyxHQUFXLEVBQ1hDLFlBQXlCLEVBQ3pCO0VBQ0EsTUFBTUMsT0FBTyxHQUFHQyxjQUFLLENBQUNDLE9BQU8sQ0FBQ0wsV0FBVyxFQUFFQyxHQUFHLEVBQUVDLFlBQVksQ0FBQztFQUM3RCxNQUFNSSxHQUFHLEdBQUcsTUFBTUgsT0FBTztFQUN6QixNQUFNSSxJQUFJLEdBQUcsTUFBTUgsY0FBSyxDQUFDSSxJQUFJLENBQUNGLEdBQUcsRUFBRUosWUFBWSxDQUFDO0VBQ2hELE9BQU9LLElBQUk7QUFDYixDQUFDO0FBQUNFLE9BQUEsQ0FBQVYsU0FBQSxHQUFBQSxTQUFBIn0=