"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inputIsSQL = exports.inputIsQuery = exports.inputIsPPL = exports.formatNotRecognized = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const inputIsQuery = inputText => {
  return inputIsSQL(inputText) || inputIsPPL(inputText);
};
exports.inputIsQuery = inputIsQuery;
const inputIsSQL = inputText => {
  return inputText.substring(0, 4) === '%sql';
};
exports.inputIsSQL = inputIsSQL;
const inputIsPPL = inputText => {
  return inputText.substring(0, 4) === '%ppl';
};
exports.inputIsPPL = inputIsPPL;
const formatNotRecognized = inputText => {
  return inputText.substring(0, 4) !== '%sql' && inputText.substring(0, 4) !== '%ppl' && inputText.substring(0, 3) !== '%md';
};
exports.formatNotRecognized = formatNotRecognized;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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