"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateParagraphText = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Helper function to get nested value from object (similar to Lodash _.get)
const getNestedValue = (obj, path, defaultValue = undefined) => {
  if (!obj || !path) return defaultValue;

  // Split by dots first, then handle array notation
  const parts = path.split('.');
  let current = obj;
  for (const part of parts) {
    if (current === null || current === undefined || typeof current !== 'object') {
      return defaultValue;
    }

    // Handle array notation like [0] or [1]
    if (part.includes('[') && part.includes(']')) {
      // Extract the property name and array index
      const match = part.match(/^([^\[]+)\[(\d+)\]$/);
      if (match) {
        const [, propName, index] = match;
        if (propName) {
          current = current[propName];
          if (current === null || current === undefined || !Array.isArray(current)) {
            return defaultValue;
          }
          current = current[parseInt(index, 10)];
        } else {
          // Direct array access like [0]
          current = current[parseInt(index, 10)];
        }
      } else {
        return defaultValue;
      }
    } else {
      current = current[part];
    }
    if (current === undefined) {
      return defaultValue;
    }
  }
  return current;
};
const updateParagraphText = (inputText, notebookInfo) => {
  var _notebookInfo$attribu;
  // Remove prefix. eg: %ppl
  const removedPrefixInput = inputText.replace(/^%\w+\s+/, '');
  const context = notebookInfo === null || notebookInfo === void 0 || (_notebookInfo$attribu = notebookInfo.attributes) === null || _notebookInfo$attribu === void 0 || (_notebookInfo$attribu = _notebookInfo$attribu.savedNotebook) === null || _notebookInfo$attribu === void 0 ? void 0 : _notebookInfo$attribu.context;
  if (!context) {
    return removedPrefixInput;
  } else {
    // Replace variables with values. eg: ${context.a[0].b.c} -> value
    const replacedVariablesInput = removedPrefixInput.replace(/\$\{([^}]+)\}/g, (match, path) => {
      // Currently we only support to retrieve value from context. So remove 'context.' prefix if it exists
      const cleanPath = path.startsWith('context.') ? path.substring(8) : path;
      const value = getNestedValue(context, cleanPath);
      // Handle null values - return "null" string instead of keeping placeholder
      if (value === null) {
        return 'null';
      }
      if (value !== undefined) {
        return String(value);
      }
      return match;
    });
    return replacedVariablesInput;
  }
};
exports.updateParagraphText = updateParagraphText;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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