"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sampleVisualizations = exports.sampleQueries = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const sampleVisualizations = exports.sampleVisualizations = [{
  name: '[Logs] Daily average bytes',
  description: '',
  query: 'source = opensearch_dashboards_sample_data_logs | stats avg(bytes) by span(timestamp,1d)',
  type: 'line',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Daily count for error response codes',
  description: '',
  query: "source = opensearch_dashboards_sample_data_logs | where response='503' or response='404' | stats count() by span(timestamp,1d)",
  type: 'bar',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Average ram usage by operating systems',
  description: '',
  query: 'source = opensearch_dashboards_sample_data_logs |  stats avg(machine.ram) by machine.os',
  type: 'horizontal_bar',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Average ram usage per day by apple os',
  description: '',
  query: "source = opensearch_dashboards_sample_data_logs | where machine.os='osx' or  machine.os='ios' |  stats avg(machine.ram) by span(timestamp,1d)",
  type: 'line',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Average ram usage per day by windows os ',
  description: '',
  query: "source = opensearch_dashboards_sample_data_logs | where match(machine.os,'win')  |  stats avg(machine.ram) by span(timestamp,1d)",
  type: 'line',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Count requests from US to CN, IN and JP',
  description: '',
  query: "source = opensearch_dashboards_sample_data_logs | where geo.src='US' | where geo.dest='JP' or geo.dest='CN' or geo.dest='IN' | stats count() by geo.dest",
  type: 'bar',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Count total requests by tags ',
  description: '',
  query: 'source = opensearch_dashboards_sample_data_logs | stats count() by tags',
  type: 'bar',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Max and average bytes by host',
  description: '',
  query: 'source = opensearch_dashboards_sample_data_logs | stats max(bytes), avg(bytes) by host',
  type: 'line',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}];
const sampleQueries = exports.sampleQueries = [{
  name: '[Flights] Show all flights sorted by most delayed',
  description: '',
  query: 'source=opensearch_dashboards_sample_data_flights  | sort -FlightDelayMin',
  selected_date_range: {
    start: 'now/M',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: [{
      name: 'Carrier',
      type: 'string'
    }, {
      name: 'Dest',
      type: 'string'
    }, {
      name: 'DestAirportID',
      type: 'string'
    }, {
      name: 'FlightDelayMin',
      type: 'integer'
    }, {
      name: 'OriginAirportID',
      type: 'string'
    }]
  }
}, {
  name: '[Logs] Show all logs lines where error code is 404 or 503',
  description: '',
  query: "source=opensearch_dashboards_sample_data_logs | where response='503' or response='404'",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Show all logs lines where error code is 404 or 503 and deduplicate consecutive entries only',
  description: '',
  query: "source=opensearch_dashboards_sample_data_logs | where response='503' or response='404' | dedup host consecutive=true",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Show all hosts with errors  aggregated by response, count of ips and tags',
  description: '',
  query: "source=opensearch_dashboards_sample_data_logs |  where response='503' or response='404' |  stats count() as ip_count by response , host , tags",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Flights] Show the count of flights by Destination and Country',
  description: '',
  query: 'source=opensearch_dashboards_sample_data_flights  | stats count() by DestCountry , Dest',
  selected_date_range: {
    start: 'now/M',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Flights] Show all Carriers sorted by average delay',
  description: '',
  query: 'source=opensearch_dashboards_sample_data_flights |where FlightDelayMin > 0 | stats sum(FlightDelayMin) as total_delay_min, count() as total_delayed by Carrier |eval avg_delay=total_delay_min / total_delayed | sort - avg_delay',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Show errors sorted by list of hostnames and average bytes per ip',
  description: '',
  query: "source=opensearch_dashboards_sample_data_logs  | where response='503' or response='404' |      stats count() as ip_count, sum(bytes)       as sum_bytes by host, response |       rename response as resp_code |       sort - ip_count, + sum_bytes |       eval per_ip_bytes=sum_bytes/ip_count",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Show errors sorted by list of hostnames, by summation of bytes',
  description: '',
  query: "source=opensearch_dashboards_sample_data_logs | where response='503' or response='404' |      stats count() as ip_count, sum(bytes)      as sum_bytes by host, response | sort -sum_bytes",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Show errors sorted by list of hostnames, by summation of bytes and complex evals',
  description: '',
  query: "source=opensearch_dashboards_sample_data_logs | where response='503' or response='404' |      stats count() as ip_count, sum(bytes)      as sum_bytes by host, response |      rename response as resp_code |      sort - ip_count, + sum_bytes |      eval per_ip_bytes=sum_bytes/ip_count,       double_per_ip_bytes = 2 * per_ip_bytes",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Show all logs where request matches filebeat',
  description: '',
  query: "source = opensearch_dashboards_sample_data_logs | where match(request,'filebeat')",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: [{
      name: 'message',
      type: 'string'
    }]
  }
}];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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