"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addSampleNotes = addSampleNotes;
exports.cloneNotebook = cloneNotebook;
exports.createNotebook = createNotebook;
exports.fetchNotebooks = fetchNotebooks;
exports.renameNotebook = renameNotebook;
var _notebooks = require("../../../common/types/notebooks");
var _observability_saved_object_attributes = require("../../../common/types/observability_saved_object_attributes");
var _sample_notebooks = require("../../../server/common/helpers/notebooks/sample_notebooks");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function fetchNotebooks(savedObjectNotebooks, agenticFeaturesEnabled) {
  const notebooks = [];
  savedObjectNotebooks.forEach(savedObject => {
    if (savedObject.type === 'observability-notebook' && savedObject.attributes.savedNotebook) {
      var _savedObject$attribut, _savedObject$attribut2;
      if (!agenticFeaturesEnabled && ((_savedObject$attribut = savedObject.attributes.savedNotebook.context) === null || _savedObject$attribut === void 0 ? void 0 : _savedObject$attribut.notebookType) === _notebooks.NotebookType.AGENTIC) return;
      notebooks.push({
        dateCreated: savedObject.attributes.savedNotebook.dateCreated,
        dateModified: savedObject.attributes.savedNotebook.dateModified,
        path: savedObject.attributes.savedNotebook.name,
        id: savedObject.id,
        notebookType: ((_savedObject$attribut2 = savedObject.attributes.savedNotebook.context) === null || _savedObject$attribut2 === void 0 ? void 0 : _savedObject$attribut2.notebookType) || _notebooks.NotebookType.CLASSIC
      });
    }
  });
  return notebooks;
}
function createNotebook(notebookName, userName) {
  var _notebookName$context;
  const noteObject = {
    dateCreated: new Date().toISOString(),
    name: notebookName.name,
    dateModified: new Date().toISOString(),
    backend: '.kibana_1.0',
    paragraphs: [],
    path: notebookName.name,
    context: (_notebookName$context = notebookName === null || notebookName === void 0 ? void 0 : notebookName.context) !== null && _notebookName$context !== void 0 ? _notebookName$context : undefined,
    hypotheses: []
  };
  if (userName) {
    noteObject.owner = userName;
  }
  return {
    savedNotebook: noteObject
  };
}
function cloneNotebook(fetchedNotebook, name) {
  const noteObject = {
    dateCreated: new Date().toISOString(),
    name,
    dateModified: new Date().toISOString(),
    backend: 'kibana_1.0',
    paragraphs: fetchedNotebook.paragraphs,
    path: name,
    owner: fetchedNotebook.owner
  };
  return {
    savedNotebook: noteObject
  };
}
function renameNotebook(noteBookObj) {
  const noteObject = {
    name: noteBookObj.name,
    dateModified: new Date().toISOString(),
    path: noteBookObj.name
  };
  return {
    savedNotebook: noteObject
  };
}
async function addSampleNotes(opensearchNotebooksClient, visIds, dataSourceId) {
  const notebooks = (0, _sample_notebooks.getSampleNotebooks)(visIds);
  const sampleNotebooks = [];
  try {
    for (const item of notebooks) {
      const finalSaveItem = item;
      if (dataSourceId !== undefined) {
        finalSaveItem.savedNotebook.paragraphs = item.savedNotebook.paragraphs.map(paragraph => ({
          ...paragraph,
          dataSourceMDSId: dataSourceId
        }));
      }
      const createdNotebooks = await opensearchNotebooksClient.create(_observability_saved_object_attributes.NOTEBOOK_SAVED_OBJECT, item);
      sampleNotebooks.push({
        dateCreated: createdNotebooks.attributes.savedNotebook.dateCreated,
        dateModified: createdNotebooks.attributes.savedNotebook.dateModified,
        name: createdNotebooks.attributes.savedNotebook.name,
        id: createdNotebooks.id,
        path: createdNotebooks.attributes.savedNotebook.name
      });
    }
    return {
      status: 'OK',
      message: '',
      body: sampleNotebooks
    };
  } catch (error) {
    console.log('error', error);
    throw new Error('Update Sample Notebook error' + error);
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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