"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isStateCompletedOrFailed = exports.extractParentInteractionId = exports.extractMemoryId = exports.extractFailedErrorMessage = exports.extractExecutorMemoryId = exports.extractCompletedResponse = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const isStateCompletedOrFailed = state => ['COMPLETED', 'FAILED'].includes(state);
exports.isStateCompletedOrFailed = isStateCompletedOrFailed;
const extractExecutorMemoryId = task => {
  var _task$response, _task$response$execut, _task$response2, _inferenceResult$outp;
  const inferenceResult = task === null || task === void 0 || (_task$response = task.response) === null || _task$response === void 0 || (_task$response = _task$response.inference_results) === null || _task$response === void 0 ? void 0 : _task$response[0];
  return (_task$response$execut = task === null || task === void 0 || (_task$response2 = task.response) === null || _task$response2 === void 0 ? void 0 : _task$response2.executor_agent_memory_id) !== null && _task$response$execut !== void 0 ? _task$response$execut : inferenceResult === null || inferenceResult === void 0 || (_inferenceResult$outp = inferenceResult.output.find(({
    name
  }) => name === 'executor_agent_memory_id')) === null || _inferenceResult$outp === void 0 ? void 0 : _inferenceResult$outp.result;
};
exports.extractExecutorMemoryId = extractExecutorMemoryId;
const extractParentInteractionId = task => {
  return task === null || task === void 0 ? void 0 : task.response.parent_interaction_id;
};
exports.extractParentInteractionId = extractParentInteractionId;
const extractMemoryId = task => {
  return task === null || task === void 0 ? void 0 : task.response.memory_id;
};
exports.extractMemoryId = extractMemoryId;
const extractCompletedResponse = task => {
  var _task$response3;
  const inferenceResult = task === null || task === void 0 || (_task$response3 = task.response) === null || _task$response3 === void 0 || (_task$response3 = _task$response3.inference_results) === null || _task$response3 === void 0 ? void 0 : _task$response3[0];
  return inferenceResult === null || inferenceResult === void 0 ? void 0 : inferenceResult.output.find(({
    name
  }) => name === 'response').dataAsMap.response;
};
exports.extractCompletedResponse = extractCompletedResponse;
const extractFailedErrorMessage = task => {
  return task.response.error_message;
};
exports.extractFailedErrorMessage = extractFailedErrorMessage;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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