"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataSourceFilterFn = void 0;
exports.get = get;
var _semver = _interopRequireDefault(require("semver"));
var pluginManifest = _interopRequireWildcard(require("../../opensearch_dashboards.json"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * TODO making this method type-safe is nontrivial: if you just define
 * `Nested<T> = { [k: string]: Nested<T> | T }` then you can't accumulate because `T` is not `Nested<T>`
 * There might be a way to define a recursive type that accumulates cleanly but it's probably not
 * worth the effort.
 */
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function get(obj, path, defaultValue) {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  return path.split('.').reduce((acc, part) => acc && acc[part], obj) || defaultValue;
}
const dataSourceFilterFn = dataSource => {
  var _dataSource$attribute, _dataSource$attribute2;
  const dataSourceVersion = (dataSource === null || dataSource === void 0 || (_dataSource$attribute = dataSource.attributes) === null || _dataSource$attribute === void 0 ? void 0 : _dataSource$attribute.dataSourceVersion) || '';
  const installedPlugins = (dataSource === null || dataSource === void 0 || (_dataSource$attribute2 = dataSource.attributes) === null || _dataSource$attribute2 === void 0 ? void 0 : _dataSource$attribute2.installedPlugins) || [];
  // Using DataSourceEngineType.opensearchServerless requires make data source as a required bundles of investigation.
  const isServerless = dataSource.attributes.dataSourceEngineType === 'OpenSearch Serverless';
  return isServerless || _semver.default.satisfies(dataSourceVersion, pluginManifest.supportedOSDataSourceVersions) && pluginManifest.requiredOSDataSourcePlugins.every(plugin => installedPlugins.includes(plugin));
};
exports.dataSourceFilterFn = dataSourceFilterFn;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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