"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setNavBreadCrumbs = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const setNavBreadCrumbs = (parentBreadCrumb, pageBreadCrumb, chrome, counter) => {
  const isNavGroupEnabled = chrome.navGroup.getNavGroupEnabled();
  const updatedPageBreadCrumb = pageBreadCrumb.map(crumb => ({
    ...crumb,
    text: isNavGroupEnabled && counter !== undefined ? `${crumb.text} (${counter})` : crumb.text
  }));
  if (isNavGroupEnabled) {
    chrome.setBreadcrumbs([...updatedPageBreadCrumb]);
  } else {
    chrome.setBreadcrumbs([...parentBreadCrumb, ...updatedPageBreadCrumb]);
  }
};
exports.setNavBreadCrumbs = setNavBreadCrumbs;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJzZXROYXZCcmVhZENydW1icyIsInBhcmVudEJyZWFkQ3J1bWIiLCJwYWdlQnJlYWRDcnVtYiIsImNocm9tZSIsImNvdW50ZXIiLCJpc05hdkdyb3VwRW5hYmxlZCIsIm5hdkdyb3VwIiwiZ2V0TmF2R3JvdXBFbmFibGVkIiwidXBkYXRlZFBhZ2VCcmVhZENydW1iIiwibWFwIiwiY3J1bWIiLCJ0ZXh0IiwidW5kZWZpbmVkIiwic2V0QnJlYWRjcnVtYnMiLCJleHBvcnRzIl0sInNvdXJjZXMiOlsic2V0X25hdl9icmVhZF9jcnVtYnMudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcclxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXHJcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXHJcbiAqL1xyXG5cclxuaW1wb3J0IHsgRXVpQnJlYWRjcnVtYiB9IGZyb20gJ0BlbGFzdGljL2V1aSc7XHJcbmltcG9ydCB7IENocm9tZVN0YXJ0IH0gZnJvbSAnLi4vLi4vLi4vLi4vc3JjL2NvcmUvcHVibGljJztcclxuXHJcbmV4cG9ydCBjb25zdCBzZXROYXZCcmVhZENydW1icyA9IChcclxuICBwYXJlbnRCcmVhZENydW1iOiBFdWlCcmVhZGNydW1iW10sXHJcbiAgcGFnZUJyZWFkQ3J1bWI6IEV1aUJyZWFkY3J1bWJbXSxcclxuICBjaHJvbWU6IENocm9tZVN0YXJ0LFxyXG4gIGNvdW50ZXI/OiBudW1iZXJcclxuKSA9PiB7XHJcbiAgY29uc3QgaXNOYXZHcm91cEVuYWJsZWQgPSBjaHJvbWUubmF2R3JvdXAuZ2V0TmF2R3JvdXBFbmFibGVkKCk7XHJcblxyXG4gIGNvbnN0IHVwZGF0ZWRQYWdlQnJlYWRDcnVtYiA9IHBhZ2VCcmVhZENydW1iLm1hcCgoY3J1bWIpID0+ICh7XHJcbiAgICAuLi5jcnVtYixcclxuICAgIHRleHQ6IGlzTmF2R3JvdXBFbmFibGVkICYmIGNvdW50ZXIgIT09IHVuZGVmaW5lZCA/IGAke2NydW1iLnRleHR9ICgke2NvdW50ZXJ9KWAgOiBjcnVtYi50ZXh0LFxyXG4gIH0pKTtcclxuXHJcbiAgaWYgKGlzTmF2R3JvdXBFbmFibGVkKSB7XHJcbiAgICBjaHJvbWUuc2V0QnJlYWRjcnVtYnMoWy4uLnVwZGF0ZWRQYWdlQnJlYWRDcnVtYl0pO1xyXG4gIH0gZWxzZSB7XHJcbiAgICBjaHJvbWUuc2V0QnJlYWRjcnVtYnMoWy4uLnBhcmVudEJyZWFkQ3J1bWIsIC4uLnVwZGF0ZWRQYWdlQnJlYWRDcnVtYl0pO1xyXG4gIH1cclxufTtcclxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQTtBQUNBO0FBQ0E7QUFDQTs7QUFLTyxNQUFNQSxpQkFBaUIsR0FBR0EsQ0FDL0JDLGdCQUFpQyxFQUNqQ0MsY0FBK0IsRUFDL0JDLE1BQW1CLEVBQ25CQyxPQUFnQixLQUNiO0VBQ0gsTUFBTUMsaUJBQWlCLEdBQUdGLE1BQU0sQ0FBQ0csUUFBUSxDQUFDQyxrQkFBa0IsQ0FBQyxDQUFDO0VBRTlELE1BQU1DLHFCQUFxQixHQUFHTixjQUFjLENBQUNPLEdBQUcsQ0FBRUMsS0FBSyxLQUFNO0lBQzNELEdBQUdBLEtBQUs7SUFDUkMsSUFBSSxFQUFFTixpQkFBaUIsSUFBSUQsT0FBTyxLQUFLUSxTQUFTLEdBQUksR0FBRUYsS0FBSyxDQUFDQyxJQUFLLEtBQUlQLE9BQVEsR0FBRSxHQUFHTSxLQUFLLENBQUNDO0VBQzFGLENBQUMsQ0FBQyxDQUFDO0VBRUgsSUFBSU4saUJBQWlCLEVBQUU7SUFDckJGLE1BQU0sQ0FBQ1UsY0FBYyxDQUFDLENBQUMsR0FBR0wscUJBQXFCLENBQUMsQ0FBQztFQUNuRCxDQUFDLE1BQU07SUFDTEwsTUFBTSxDQUFDVSxjQUFjLENBQUMsQ0FBQyxHQUFHWixnQkFBZ0IsRUFBRSxHQUFHTyxxQkFBcUIsQ0FBQyxDQUFDO0VBQ3hFO0FBQ0YsQ0FBQztBQUFDTSxPQUFBLENBQUFkLGlCQUFBLEdBQUFBLGlCQUFBIn0=