"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parsePPLQuery = parsePPLQuery;
var _antlrGrammar = require("@osd/antlr-grammar");
var _antlr4ng = require("antlr4ng");
var _moment = _interopRequireDefault(require("moment"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
// ParseTreeListener
class PPLQueryParserVisitor extends _antlrGrammar.OpenSearchPPLParserVisitor {
  constructor(query, _now) {
    super();
    _defineProperty(this, "query", void 0);
    _defineProperty(this, "now", void 0);
    _defineProperty(this, "result", {
      pplWithAbsoluteTime: '',
      compareExprs: []
    });
    _defineProperty(this, "relativeTimeReplacements", []);
    _defineProperty(this, "visitEvalFunctionCall", ctx => {
      if (!ctx.start || !ctx.stop) return;
      const dateFnCtx = ctx.evalFunctionName().dateTimeFunctionName();
      if (!dateFnCtx) {
        var _ctx$children;
        (_ctx$children = ctx.children) === null || _ctx$children === void 0 || _ctx$children.forEach(child => {
          child.accept(this);
        });
        return;
      }
      const usingRelativeTime = dateFnCtx.NOW() || dateFnCtx.CURDATE() || dateFnCtx.CURRENT_DATE() || dateFnCtx.CURRENT_TIME() || dateFnCtx.CURRENT_TIMESTAMP();
      if (!usingRelativeTime) {
        var _ctx$children2;
        (_ctx$children2 = ctx.children) === null || _ctx$children2 === void 0 || _ctx$children2.forEach(child => {
          child.accept(this);
        });
        return;
      }
      const funcName = dateFnCtx.getText().toLowerCase();
      let now = (0, _moment.default)(new Date()).utc();
      if (this.now) {
        now = (0, _moment.default)(this.now).utc();
      }
      const formattedDate = now.format('YYYY-MM-DD HH:mm:ss');
      const formattedDateOnly = now.format('YYYY-MM-DD');
      const formattedTimeOnly = now.format('HH:mm:ss');
      const replacements = {
        now: `timestamp('${formattedDate}')`,
        curdate: `'${formattedDateOnly}'`,
        current_date: `'${formattedDateOnly}'`,
        current_time: `'${formattedTimeOnly}'`,
        current_timestamp: `timestamp('${formattedDate}')`
      };
      if (replacements[funcName]) {
        this.relativeTimeReplacements.push({
          start: ctx.start.start,
          stop: ctx.stop.stop,
          replacement: replacements[funcName]
        });
      }
    });
    _defineProperty(this, "visitFromClause", ctx => {
      if (!ctx.start || !ctx.stop) return;
      this.result.fromClause = {
        start: ctx.start.start,
        stop: ctx.stop.stop,
        text: this.query.substring(ctx.start.start, ctx.stop.stop + 1)
      };
    });
    _defineProperty(this, "visitCompareExpr", ctx => {
      const left = ctx._left;
      const right = ctx._right;
      const operator = ctx.comparisonOperator();
      if ((operator.LESS() || operator.NOT_LESS() || operator.GREATER() || operator.NOT_GREATER()) && left !== null && left !== void 0 && left.start && left.stop && right !== null && right !== void 0 && right.start && right.stop) {
        var _this$result$compareE, _left$start, _left$stop, _right$start, _right$stop;
        (_this$result$compareE = this.result.compareExprs) === null || _this$result$compareE === void 0 || _this$result$compareE.push({
          left: this.query.substring((_left$start = left.start) === null || _left$start === void 0 ? void 0 : _left$start.start, ((_left$stop = left.stop) === null || _left$stop === void 0 ? void 0 : _left$stop.stop) + 1),
          right: this.query.substring((_right$start = right.start) === null || _right$start === void 0 ? void 0 : _right$start.start, ((_right$stop = right.stop) === null || _right$stop === void 0 ? void 0 : _right$stop.stop) + 1),
          op: operator.getText()
        });
      }
      ctx.children.forEach(child => child.accept(this));
    });
    this.query = query;
    this.now = _now;
  }
}
function parsePPLQuery(query, now) {
  const inputStream = _antlr4ng.CharStream.fromString(query);
  const lexer = new _antlrGrammar.OpenSearchPPLLexer(inputStream);
  const tokenStream = new _antlr4ng.CommonTokenStream(lexer);
  const parser = new _antlrGrammar.OpenSearchPPLParser(tokenStream);
  const tree = parser.root();
  const listener = new PPLQueryParserVisitor(query, now);
  tree.accept(listener);

  // Apply replacements from end to start to maintain positions
  const sortedReplacements = listener.relativeTimeReplacements.sort((a, b) => a.start - b.start);
  let result = '';
  let lastIndex = 0;
  for (const {
    start,
    stop,
    replacement
  } of sortedReplacements) {
    result += query.substring(lastIndex, start) + replacement;
    lastIndex = stop + 1;
  }
  result += query.substring(lastIndex);
  listener.result.pplWithAbsoluteTime = result;
  return listener.result;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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