"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInputType = exports.extractCodeBlockType = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const extractCodeBlockType = content => {
  var _content$match;
  const regexp = /^%(\w+)\s+/;
  return ((_content$match = content.match(regexp)) === null || _content$match === void 0 ? void 0 : _content$match[1]) || '';
};
exports.extractCodeBlockType = extractCodeBlockType;
const getInputType = paragraph => {
  const inputType = paragraph.input.inputType;
  if (inputType === 'MARKDOWN' || inputType === 'CODE') {
    return extractCodeBlockType(paragraph.input.inputText);
  }
  return inputType;
};
exports.getInputType = getInputType;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJleHRyYWN0Q29kZUJsb2NrVHlwZSIsImNvbnRlbnQiLCJfY29udGVudCRtYXRjaCIsInJlZ2V4cCIsIm1hdGNoIiwiZXhwb3J0cyIsImdldElucHV0VHlwZSIsInBhcmFncmFwaCIsImlucHV0VHlwZSIsImlucHV0IiwiaW5wdXRUZXh0Il0sInNvdXJjZXMiOlsicGFyYWdyYXBoLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXHJcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xyXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxyXG4gKi9cclxuXHJcbmltcG9ydCB7IFBhcmFncmFwaEJhY2tlbmRUeXBlIH0gZnJvbSAnY29tbW9uL3R5cGVzL25vdGVib29rcyc7XHJcblxyXG5leHBvcnQgY29uc3QgZXh0cmFjdENvZGVCbG9ja1R5cGUgPSAoY29udGVudDogc3RyaW5nKSA9PiB7XHJcbiAgY29uc3QgcmVnZXhwID0gL14lKFxcdyspXFxzKy87XHJcbiAgcmV0dXJuIGNvbnRlbnQubWF0Y2gocmVnZXhwKT8uWzFdIHx8ICcnO1xyXG59O1xyXG5cclxuZXhwb3J0IGNvbnN0IGdldElucHV0VHlwZSA9IDxUPihwYXJhZ3JhcGg6IFBhcmFncmFwaEJhY2tlbmRUeXBlPFQ+KSA9PiB7XHJcbiAgY29uc3QgaW5wdXRUeXBlID0gcGFyYWdyYXBoLmlucHV0LmlucHV0VHlwZTtcclxuICBpZiAoaW5wdXRUeXBlID09PSAnTUFSS0RPV04nIHx8IGlucHV0VHlwZSA9PT0gJ0NPREUnKSB7XHJcbiAgICByZXR1cm4gZXh0cmFjdENvZGVCbG9ja1R5cGUocGFyYWdyYXBoLmlucHV0LmlucHV0VGV4dCk7XHJcbiAgfVxyXG5cclxuICByZXR1cm4gaW5wdXRUeXBlO1xyXG59O1xyXG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBO0FBQ0E7QUFDQTtBQUNBOztBQUlPLE1BQU1BLG9CQUFvQixHQUFJQyxPQUFlLElBQUs7RUFBQSxJQUFBQyxjQUFBO0VBQ3ZELE1BQU1DLE1BQU0sR0FBRyxZQUFZO0VBQzNCLE9BQU8sRUFBQUQsY0FBQSxHQUFBRCxPQUFPLENBQUNHLEtBQUssQ0FBQ0QsTUFBTSxDQUFDLGNBQUFELGNBQUEsdUJBQXJCQSxjQUFBLENBQXdCLENBQUMsQ0FBQyxLQUFJLEVBQUU7QUFDekMsQ0FBQztBQUFDRyxPQUFBLENBQUFMLG9CQUFBLEdBQUFBLG9CQUFBO0FBRUssTUFBTU0sWUFBWSxHQUFPQyxTQUFrQyxJQUFLO0VBQ3JFLE1BQU1DLFNBQVMsR0FBR0QsU0FBUyxDQUFDRSxLQUFLLENBQUNELFNBQVM7RUFDM0MsSUFBSUEsU0FBUyxLQUFLLFVBQVUsSUFBSUEsU0FBUyxLQUFLLE1BQU0sRUFBRTtJQUNwRCxPQUFPUixvQkFBb0IsQ0FBQ08sU0FBUyxDQUFDRSxLQUFLLENBQUNDLFNBQVMsQ0FBQztFQUN4RDtFQUVBLE9BQU9GLFNBQVM7QUFDbEIsQ0FBQztBQUFDSCxPQUFBLENBQUFDLFlBQUEsR0FBQUEsWUFBQSJ9