"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiSettingsService = exports.setOSDSavedObjectsClient = exports.setOSDHttp = exports.getOSDSavedObjectsClient = exports.getOSDHttp = void 0;
var _common = require("../../../../src/plugins/opensearch_dashboards_utils/common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

let uiSettings;
let notifications;
const uiSettingsService = exports.uiSettingsService = {
  init: (client, notificationsStart) => {
    uiSettings = client;
    notifications = notificationsStart;
  },
  get: (key, defaultOverride) => {
    var _uiSettings;
    return ((_uiSettings = uiSettings) === null || _uiSettings === void 0 ? void 0 : _uiSettings.get(key, defaultOverride)) || '';
  },
  set: (key, value) => {
    var _uiSettings2;
    return ((_uiSettings2 = uiSettings) === null || _uiSettings2 === void 0 ? void 0 : _uiSettings2.set(key, value)) || Promise.reject('uiSettings client not initialized.');
  },
  addToast: toast => {
    return notifications.toasts.add(toast);
  }
};
const [getOSDHttp, setOSDHttp] = (0, _common.createGetterSetter)('http');
exports.setOSDHttp = setOSDHttp;
exports.getOSDHttp = getOSDHttp;
const [getOSDSavedObjectsClient, setOSDSavedObjectsClient] = (0, _common.createGetterSetter)('SavedObjectsClient');
exports.setOSDSavedObjectsClient = setOSDSavedObjectsClient;
exports.getOSDSavedObjectsClient = getOSDSavedObjectsClient;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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