"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ParagraphState = void 0;
var _observable_state = require("./observable_state");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class ParagraphState extends _observable_state.ObservableState {
  static getOutput(value) {
    var _value$output;
    if (!value) {
      return undefined;
    }
    return (_value$output = value.output) === null || _value$output === void 0 ? void 0 : _value$output[0];
  }
  static updateOutputResult(value, newResult) {
    var _value$output2;
    if (!value || !((_value$output2 = value.output) !== null && _value$output2 !== void 0 && _value$output2[0])) {
      return value;
    }
    const newValue = JSON.parse(JSON.stringify({
      ...value
    }));
    if (typeof newResult === 'string') {
      newValue.output[0].result = newResult;
    } else {
      newValue.output[0].result = {
        ...newValue.output[0].result,
        ...newResult
      };
    }
    return newValue;
  }
  formatValue(value) {
    return {
      ...value,
      uiState: {
        viewMode: 'output_only',
        ...value.uiState
      }
    };
  }
  getParagraphType() {
    return this.value.input.inputType;
  }
  getBackendValue() {
    const {
      input,
      output,
      id,
      dateModified,
      dateCreated,
      dataSourceMDSId
    } = this.value;
    return {
      input,
      output,
      id,
      dateModified,
      dateCreated,
      dataSourceMDSId
    };
  }
  updateInput(input) {
    var _this$value$input;
    const {
      parameters,
      ...others
    } = (_this$value$input = this.value.input) !== null && _this$value$input !== void 0 ? _this$value$input : {};
    const {
      parameters: inputParameters,
      ...inputOthers
    } = input !== null && input !== void 0 ? input : {};
    let payload = {
      ...others,
      ...inputOthers
    };
    if (parameters || inputParameters) {
      payload = {
        ...payload,
        parameters: {
          ...parameters,
          ...inputParameters
        }
      };
    }
    this.updateValue({
      input: payload
    });
    return this;
  }
  updateOutput(output) {
    var _this$value$output;
    this.updateValue({
      output: [{
        ...(((_this$value$output = this.value.output) === null || _this$value$output === void 0 ? void 0 : _this$value$output[0]) || {}),
        ...output
      }]
    });
  }
  updateFullfilledOutput(fullfilledOutput) {
    this.updateValue({
      fullfilledOutput: {
        ...this.value.fullfilledOutput,
        ...fullfilledOutput
      }
    });
  }
  resetFullfilledOutput() {
    this.updateValue({
      fullfilledOutput: {}
    });
  }
  updateUIState(uiState) {
    this.updateValue({
      uiState: {
        ...this.value.uiState,
        ...uiState
      }
    });
  }
}
exports.ParagraphState = ParagraphState;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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