"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservableState = void 0;
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class ObservableState {
  constructor(initialValue) {
    _defineProperty(this, "value$", void 0);
    this.value$ = new _rxjs.BehaviorSubject(this.formatValue(initialValue));
  }
  get value() {
    return this.value$.getValue();
  }
  formatValue(value) {
    return value;
  }
  getValue$() {
    return this.value$.pipe((0, _operators.map)(item => item));
  }
  updateValue(value) {
    this.value$.next({
      ...this.value$.getValue(),
      ...value
    });
    return this;
  }
  destroy() {
    this.value$.unsubscribe();
    this.value$.complete();
  }
}
exports.ObservableState = ObservableState;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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