"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isInvestigationActive = exports.NotebookState = exports.InvestigationPhase = void 0;
var _operators = require("rxjs/operators");
var _observable_state = require("./observable_state");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
let InvestigationPhase = exports.InvestigationPhase = /*#__PURE__*/function (InvestigationPhase) {
  InvestigationPhase["PLANNING"] = "planning";
  InvestigationPhase["RETRIEVING_CONTEXT"] = "retrieving_context";
  InvestigationPhase["GATHERING_DATA"] = "gathering_data";
  InvestigationPhase["COMPLETED"] = "completed";
  return InvestigationPhase;
}({});
const isInvestigationActive = phase => {
  return phase === InvestigationPhase.PLANNING || phase === InvestigationPhase.RETRIEVING_CONTEXT || phase === InvestigationPhase.GATHERING_DATA;
};
exports.isInvestigationActive = isInvestigationActive;
class NotebookState extends _observable_state.ObservableState {
  updateContext(context) {
    this.value.context.updateValue(context);
    return this;
  }
  getContext() {
    return this.value.context.value;
  }
  deleteParagraph(paragraphId) {
    const newParagraph = this.value.paragraphs;
    const findIndex = newParagraph.findIndex(paragraph => paragraph.value.id === paragraphId);
    if (findIndex > -1) {
      newParagraph.splice(findIndex, 1);
    }
    this.updateValue({
      paragraphs: newParagraph
    });
    return this;
  }
  getParagraphStates$() {
    return this.getValue$().pipe((0, _operators.map)(state => state.paragraphs), (0, _operators.distinctUntilChanged)((a, b) => {
      if (a.length !== b.length) return false;
      for (let i = 0; i < a.length; i++) {
        if (a !== b) return false;
      }
      return true;
    }));
  }
  getParagraphsValue() {
    return this.value.paragraphs.map(paragraph => paragraph.value);
  }
  // this is used for get pure backend values that needs to be persist into backend
  getParagraphsBackendValue() {
    return this.value.paragraphs.map(paragraph => paragraph.getBackendValue());
  }
}
exports.NotebookState = NotebookState;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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