"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.observabilityLogsID = exports.investigationNotebookTitle = exports.investigationNotebookPluginOrder = exports.investigationNotebookID = exports.UI_DATE_FORMAT = exports.SQL_ENDPOINT = exports.SQL_DOCUMENTATION_URL = exports.SECURITY_PLUGIN_ACCOUNT_API = exports.SAVED_VISUALIZATION = exports.SAVED_QUERY = exports.SAVED_OBJECTS = exports.SAVED_OBJECT = exports.PPL_SEARCH = exports.PPL_ENDPOINT = exports.PPL_DOCUMENTATION_URL = exports.PPL_BASE = exports.OPENSEARCH_DATACONNECTIONS_API = exports.OBSERVABILITY_BASE = exports.EVENT_ANALYTICS = exports.ENABLE_AI_FEATURES = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Client route
const PPL_BASE = exports.PPL_BASE = '/api/investigation/ppl';
const PPL_SEARCH = exports.PPL_SEARCH = '/search';
const OBSERVABILITY_BASE = exports.OBSERVABILITY_BASE = '/api/observability';
const EVENT_ANALYTICS = exports.EVENT_ANALYTICS = '/event_analytics';
const SAVED_OBJECTS = exports.SAVED_OBJECTS = '/saved_objects';
const SAVED_QUERY = exports.SAVED_QUERY = '/query';
const SAVED_VISUALIZATION = exports.SAVED_VISUALIZATION = '/vis';
const SECURITY_PLUGIN_ACCOUNT_API = exports.SECURITY_PLUGIN_ACCOUNT_API = '/api/v1/configuration/account';

// Server route
const PPL_ENDPOINT = exports.PPL_ENDPOINT = '/_plugins/_ppl';
const SQL_ENDPOINT = exports.SQL_ENDPOINT = '/_plugins/_sql';
const investigationNotebookID = exports.investigationNotebookID = 'investigation-notebooks';
const investigationNotebookTitle = exports.investigationNotebookTitle = 'Notebooks';
const investigationNotebookPluginOrder = exports.investigationNotebookPluginOrder = 5094;

// Shared Constants
const SQL_DOCUMENTATION_URL = exports.SQL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/index/';
const PPL_DOCUMENTATION_URL = exports.PPL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/ppl/index';
const UI_DATE_FORMAT = exports.UI_DATE_FORMAT = 'MM/DD/YYYY hh:mm A';
const BASE_DATACONNECTIONS_URI = '/_plugins/_query/_datasources';
const OPENSEARCH_DATACONNECTIONS_API = exports.OPENSEARCH_DATACONNECTIONS_API = {
  DATACONNECTION: `${BASE_DATACONNECTIONS_URI}`
};

// Saved Objects
const SAVED_OBJECT = exports.SAVED_OBJECT = '/object';
const observabilityLogsID = exports.observabilityLogsID = 'observability-logs';
const ENABLE_AI_FEATURES = exports.ENABLE_AI_FEATURES = 'enableAIFeatures';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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