"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.errorKeywords = exports.dateFormat = exports.PPL_PARAGRAPH_TYPE = exports.OTHER_PARAGRAPH_TYPE = exports.OPENSEARCH_NOTEBOOKS_API = exports.OBSERVABILITY_VISUALIZATION_TYPE = exports.NOTEBOOK_NAME_MAX_LENGTH = exports.NOTEBOOK_APP_NAME = exports.NOTEBOOKS_FETCH_SIZE = exports.NOTEBOOKS_DOCUMENTATION_URL = exports.NOTEBOOKS_API_PREFIX = exports.LOG_PATTERN_PARAGRAPH_TYPE = exports.EXPLORE_VISUALIZATION_TYPE = exports.DEFAULT_VISUALIZATION_NAME = exports.DEFAULT_INVESTIGATION_NAME = exports.DATA_DISTRIBUTION_PARAGRAPH_TYPE = exports.DASHBOARDS_VISUALIZATION_TYPE = exports.CREATE_NOTE_MESSAGE = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const NOTEBOOKS_API_PREFIX = exports.NOTEBOOKS_API_PREFIX = '/api/investigation';
const NOTEBOOKS_FETCH_SIZE = exports.NOTEBOOKS_FETCH_SIZE = 1000;
const CREATE_NOTE_MESSAGE = exports.CREATE_NOTE_MESSAGE = 'Enter a name to describe the purpose of this notebook.';
const NOTEBOOKS_DOCUMENTATION_URL = exports.NOTEBOOKS_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/observability-plugin/notebooks/';
const NOTEBOOK_NAME_MAX_LENGTH = exports.NOTEBOOK_NAME_MAX_LENGTH = 50;
const BASE_NOTEBOOKS_URI = '/_plugins/_notebooks';
const OPENSEARCH_NOTEBOOKS_API = exports.OPENSEARCH_NOTEBOOKS_API = {
  GET_NOTEBOOKS: `${BASE_NOTEBOOKS_URI}/notebooks`,
  NOTEBOOK: `${BASE_NOTEBOOKS_URI}/notebook`
};

// Paragraph types
const LOG_PATTERN_PARAGRAPH_TYPE = exports.LOG_PATTERN_PARAGRAPH_TYPE = 'LOG_PATTERN';
const DATA_DISTRIBUTION_PARAGRAPH_TYPE = exports.DATA_DISTRIBUTION_PARAGRAPH_TYPE = 'ANOMALY_ANALYSIS';
const PPL_PARAGRAPH_TYPE = exports.PPL_PARAGRAPH_TYPE = 'ppl';
const OTHER_PARAGRAPH_TYPE = exports.OTHER_PARAGRAPH_TYPE = 'OTHER';

// common log errors
const errorKeywords = exports.errorKeywords = /\b(error|exception|failed|failure|panic|crash|fatal|abort|timeout|unavailable|denied|rejected|invalid|corrupt|broken|dead|kill)\b/gi;
const dateFormat = exports.dateFormat = 'YYYY-MM-DD HH:mm:ss.SSS';
const NOTEBOOK_APP_NAME = exports.NOTEBOOK_APP_NAME = 'investigate-notebook';
const OBSERVABILITY_VISUALIZATION_TYPE = exports.OBSERVABILITY_VISUALIZATION_TYPE = 'observability-visualization';
const DASHBOARDS_VISUALIZATION_TYPE = exports.DASHBOARDS_VISUALIZATION_TYPE = 'visualization';
const DEFAULT_INVESTIGATION_NAME = exports.DEFAULT_INVESTIGATION_NAME = 'Discover investigation';
const DEFAULT_VISUALIZATION_NAME = exports.DEFAULT_VISUALIZATION_NAME = 'Visualization investigation';
const EXPLORE_VISUALIZATION_TYPE = exports.EXPLORE_VISUALIZATION_TYPE = 'explore';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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