"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOrderedJson = exports.filterByMinimatch = void 0;
var _minimatch = _interopRequireDefault(require("minimatch"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// minimatch is a peer dependency of glob

const filterByMinimatch = (input, rules) => {
  return rules.some(item => (0, _minimatch.default)(input, item, {
    dot: true
  }));
};
exports.filterByMinimatch = filterByMinimatch;
const getOrderedJson = json => {
  const entries = Object.entries(json);
  entries.sort((a, b) => a[0] < b[0] ? -1 : 1);
  return entries.reduce((total, [key, value]) => ({
    ...total,
    [key]: value
  }), {});
};
exports.getOrderedJson = getOrderedJson;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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