"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SYSTEM_INDEX = exports.SYSTEM_ALIAS = exports.REQUEST = exports.NODE_API = exports.BASE_API_PATH = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const BASE_API_PATH = exports.BASE_API_PATH = "/api/ism";
const NODE_API = exports.NODE_API = Object.freeze({
  _SEARCH: `${BASE_API_PATH}/_search`,
  _SEARCH_SAMPLE_DATA: `${BASE_API_PATH}/_searchSampleData`,
  _INDICES: `${BASE_API_PATH}/_indices`,
  _DATA_STREAMS: `${BASE_API_PATH}/_data_streams`,
  _ALIASES: `${BASE_API_PATH}/_aliases`,
  _MAPPINGS: `${BASE_API_PATH}/_mappings`,
  APPLY_POLICY: `${BASE_API_PATH}/applyPolicy`,
  EDIT_ROLLOVER_ALIAS: `${BASE_API_PATH}/editRolloverAlias`,
  POLICIES: `${BASE_API_PATH}/policies`,
  _RECOVERY: `${BASE_API_PATH}/_recovery`,
  ROLLUPS: `${BASE_API_PATH}/rollups`,
  TRANSFORMS: `${BASE_API_PATH}/transforms`,
  MANAGED_INDICES: `${BASE_API_PATH}/managedIndices`,
  CHANNELS: `${BASE_API_PATH}/_notifications/channels`,
  RETRY: `${BASE_API_PATH}/retry`,
  CHANGE_POLICY: `${BASE_API_PATH}/changePolicy`,
  REMOVE_POLICY: `${BASE_API_PATH}/removePolicy`,
  SMPolicies: `${BASE_API_PATH}/smPolicies`,
  _SNAPSHOTS: `${BASE_API_PATH}/_snapshots`,
  _REPOSITORIES: `${BASE_API_PATH}/_repositores`,
  PUT_INDEX: `${BASE_API_PATH}/putIndex`,
  API_CALLER: `${BASE_API_PATH}/apiCaller`,
  ACCOUNT_INFO: `${BASE_API_PATH}/accountInfo`
});
const REQUEST = exports.REQUEST = Object.freeze({
  PUT: "PUT",
  DELETE: "DELETE",
  GET: "GET",
  POST: "POST",
  HEAD: "HEAD"
});
const SYSTEM_INDEX = exports.SYSTEM_INDEX = [".plugins-ml-model", ".plugins-ml-task", ".opendistro-alerting-config", ".opendistro-alerting-alert*", ".opendistro-anomaly-results*", ".opendistro-anomaly-detector*", ".opendistro-anomaly-checkpoints", ".opendistro-anomaly-detection-state", ".opendistro-reports-*", ".opensearch-notifications-*", ".opensearch-notebooks", ".opensearch-observability", ".opendistro-asynchronous-search-response*", ".opendistro_security", ".opendistro-job-scheduler-lock", ".opendistro-ism-config", ".replication-metadata-store", "kibana*", ".kibana*", ".tasks"];
const SYSTEM_ALIAS = exports.SYSTEM_ALIAS = [".plugins*", ".opendistro*", ".opensearch*", ".replication-metadata-store", "kibana*", ".kibana*", ".tasks"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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