"use strict";

require("@testing-library/jest-dom/extend-expect");
var _react = require("@testing-library/react");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

(0, _react.configure)({
  testIdAttribute: "data-test-subj",
  asyncUtilTimeout: 10000
});
jest.mock("@elastic/eui/lib/eui_components/form/form_row/make_id", () => () => "some_make_id");
jest.mock("@elastic/eui/lib/services/accessibility/html_id_generator", () => ({
  htmlIdGenerator: () => {
    return () => "some_html_id";
  }
}));

// @ts-ignore
window.Worker = function () {
  this.postMessage = () => {};
  // @ts-ignore
  this.terminate = () => {};
};

// @ts-ignore
window.URL = {
  createObjectURL: () => {
    return "";
  }
};

// https://github.com/elastic/eui/issues/2530
jest.mock("@elastic/eui/lib/eui_components/icon", () => ({
  EuiIcon: () => "EuiIconMock",
  __esModule: true,
  IconPropType: require("@elastic/eui/lib/eui_components/icon/icon").IconPropType,
  ICON_TYPES: require("@elastic/eui/lib/eui_components/icon/icon").TYPES,
  ICON_SIZES: require("@elastic/eui/lib/eui_components/icon/icon").SIZES,
  ICON_COLORS: require("@elastic/eui/lib/eui_components/icon/icon").COLORS
}));
jest.setTimeout(60000); // in milliseconds
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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