"use strict";

var _events = require("events");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/* eslint-disable */
// transpiled typescript->javascript from
// https://github.com/aurelia/pal-nodejs/blob/master/src/polyfills/mutation-observer.ts

/*
 * Based on Shim for MutationObserver interface
 * Author: Graeme Yeates (github.com/megawac)
 * Repository: https://github.com/megawac/MutationObserver.js
 */

var __extends = void 0 && (void 0).__extends || function () {
  var extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };
  return function (d, b) {
    extendStatics(d, b);
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
}();
module.exports = {};
Object.defineProperty(module.exports, "__esModule", {
  value: true
});
var Util = /** @class */function () {
  function Util() {}
  Util.clone = function ($target, config) {
    var recurse = true; // set true so childList we'll always check the first level
    return function copy($target) {
      var elestruct = {
        /** @type {Node} */
        node: $target,
        charData: null,
        attr: null,
        kids: null
      };
      // Store current character data of target text or comment node if the config requests
      // those properties to be observed.
      if (config.charData && ($target.nodeType === 3 || $target.nodeType === 8)) {
        elestruct.charData = $target.nodeValue;
      } else {
        // Add attr only if subtree is specified or top level and avoid if
        // attributes is a document object (#13).
        if (config.attr && recurse && $target.nodeType === 1) {
          /**
           * clone live attribute list to an object structure {name: val}
           * @type {Object.<string, string>}
           */
          elestruct.attr = Util.reduce($target.attributes, function (memo, attr) {
            if (!config.afilter || config.afilter[attr.name]) {
              memo[attr.name] = attr.value;
            }
            return memo;
          }, {});
        }
        // whether we should iterate the children of $target node
        if (recurse && (config.kids || config.charData || config.attr && config.descendents)) {
          /** @type {Array.<!Object>} : Array of custom clone */
          elestruct.kids = Util.map($target.childNodes, copy);
        }
        recurse = config.descendents;
      }
      return elestruct;
    }($target);
  };
  /**
   * indexOf an element in a collection of custom nodes
   *
   * @param {NodeList} set
   * @param {!Object} $node : A custom cloned nodeg333
   * @param {number} idx : index to start the loop
   * @return {number}
   */
  Util.indexOfCustomNode = function (set, $node, idx) {
    var JSCompiler_renameProperty = function (a) {
      return a;
    };
    return this.indexOf(set, $node, idx, JSCompiler_renameProperty("node"));
  };
  /**
   * Attempt to uniquely id an element for hashing. We could optimize this for legacy browsers but it hopefully wont be called enough to be a concern
   *
   * @param {Node} $ele
   * @return {(string|number)}
   */
  Util.getElementId = function ($ele) {
    try {
      return $ele.id || ($ele[this.expando] = $ele[this.expando] || this.counter++);
    } catch (e) {
      // ie <8 will throw if you set an unknown property on a text node
      try {
        return $ele.nodeValue; // naive
      } catch (shitie) {
        // when text node is removed: https://gist.github.com/megawac/8355978 :(
        return this.counter++;
      }
    }
  };
  /**
   * **map** Apply a mapping function to each item of a set
   * @param {Array|NodeList} set
   * @param {Function} iterator
   */
  Util.map = function (set, iterator) {
    var results = [];
    for (var index = 0; index < set.length; index++) {
      results[index] = iterator(set[index], index, set);
    }
    return results;
  };
  /**
   * **Reduce** builds up a single result from a list of values
   * @param {Array|NodeList|NamedNodeMap} set
   * @param {Function} iterator
   * @param {*} [memo] Initial value of the memo.
   */
  Util.reduce = function (set, iterator, memo) {
    for (var index = 0; index < set.length; index++) {
      memo = iterator(memo, set[index], index, set);
    }
    return memo;
  };
  /**
   * **indexOf** find index of item in collection.
   * @param {Array|NodeList} set
   * @param {Object} item
   * @param {number} idx
   * @param {string} [prop] Property on set item to compare to item
   */
  Util.indexOf = function (set, item, idx, prop) {
    for (; /*idx = ~~idx*/idx < set.length; idx++) {
      // start idx is always given as this is internal
      if ((prop ? set[idx][prop] : set[idx]) === item) return idx;
    }
    return -1;
  };
  /**
   * @param {Object} obj
   * @param {(string|number)} prop
   * @return {boolean}
   */
  Util.has = function (obj, prop) {
    return obj[prop] !== undefined; // will be nicely inlined by gcc
  };

  Util.counter = 1;
  Util.expando = "mo_id";
  return Util;
}();
module.exports.Util = Util;
var MutationObserver = /** @class */function () {
  function MutationObserver(listener) {
    var _this = this;
    this._watched = [];
    this._listener = null;
    this._period = 30;
    this._timeout = null;
    this._disposed = false;
    this._notifyListener = null;
    this._watched = [];
    this._listener = listener;
    this._period = 30;
    this._notifyListener = function () {
      _this.scheduleMutationCheck(_this);
    };
  }
  MutationObserver.prototype.observe = function ($target, config) {
    var settings = {
      attr: !!(config.attributes || config.attributeFilter || config.attributeOldValue),
      // some browsers enforce that subtree must be set with childList, attributes or characterData.
      // We don't care as spec doesn't specify this rule.
      kids: !!config.childList,
      descendents: !!config.subtree,
      charData: !!(config.characterData || config.characterDataOldValue),
      afilter: null
    };
    MutationNotifier.getInstance().on("changed", this._notifyListener);
    var watched = this._watched;
    // remove already observed target element from pool
    for (var i = 0; i < watched.length; i++) {
      if (watched[i].tar === $target) watched.splice(i, 1);
    }
    if (config.attributeFilter) {
      /**
       * converts to a {key: true} dict for faster lookup
       * @type {Object.<String,Boolean>}
       */
      settings.afilter = Util.reduce(config.attributeFilter, function (a, b) {
        a[b] = true;
        return a;
      }, {});
    }
    watched.push({
      tar: $target,
      fn: this.createMutationSearcher($target, settings)
    });
  };
  MutationObserver.prototype.takeRecords = function () {
    var mutations = [];
    var watched = this._watched;
    for (var i = 0; i < watched.length; i++) {
      watched[i].fn(mutations);
    }
    return mutations;
  };
  MutationObserver.prototype.disconnect = function () {
    this._watched = []; // clear the stuff being observed
    MutationNotifier.getInstance().removeListener("changed", this._notifyListener);
    this._disposed = true;
    clearTimeout(this._timeout); // ready for garbage collection
    this._timeout = null;
  };
  MutationObserver.prototype.createMutationSearcher = function ($target, config) {
    var _this = this;
    /** type {Elestuct} */
    var $oldstate = Util.clone($target, config); // create the cloned datastructure
    /**
     * consumes array of mutations we can push to
     *
     * @param {Array.<MutationRecord>} mutations
     */
    return function (mutations) {
      var olen = mutations.length;
      var dirty;
      if (config.charData && $target.nodeType === 3 && $target.nodeValue !== $oldstate.charData) {
        mutations.push(new MutationRecord({
          type: "characterData",
          target: $target,
          oldValue: $oldstate.charData
        }));
      }
      // Alright we check base level changes in attributes... easy
      if (config.attr && $oldstate.attr) {
        _this.findAttributeMutations(mutations, $target, $oldstate.attr, config.afilter);
      }
      // check childlist or subtree for mutations
      if (config.kids || config.descendents) {
        dirty = _this.searchSubtree(mutations, $target, $oldstate, config);
      }
      // reclone data structure if theres changes
      if (dirty || mutations.length !== olen) {
        /** type {Elestuct} */
        $oldstate = Util.clone($target, config);
      }
    };
  };
  MutationObserver.prototype.scheduleMutationCheck = function (observer) {
    var _this = this;
    // Only schedule if there isn't already a timer.
    if (!observer._timeout) {
      observer._timeout = setTimeout(function () {
        return _this.mutationChecker(observer);
      }, this._period);
    }
  };
  MutationObserver.prototype.mutationChecker = function (observer) {
    // allow scheduling a new timer.
    observer._timeout = null;
    var mutations = observer.takeRecords();
    if (mutations.length) {
      // fire away
      // calling the listener with context is not spec but currently consistent with FF and WebKit
      observer._listener(mutations, observer);
    }
  };
  MutationObserver.prototype.searchSubtree = function (mutations, $target, $oldstate, config) {
    var _this = this;
    // Track if the tree is dirty and has to be recomputed (#14).
    var dirty;
    /*
     * Helper to identify node rearrangment and stuff...
     * There is no gaurentee that the same node will be identified for both added and removed nodes
     * if the positions have been shuffled.
     * conflicts array will be emptied by end of operation
     */
    var _resolveConflicts = function (conflicts, node, $kids, $oldkids, numAddedNodes) {
      // the distance between the first conflicting node and the last
      var distance = conflicts.length - 1;
      // prevents same conflict being resolved twice consider when two nodes switch places.
      // only one should be given a mutation event (note -~ is used as a math.ceil shorthand)
      var counter = -~((distance - numAddedNodes) / 2);
      var $cur;
      var oldstruct;
      var conflict;
      while (conflict = conflicts.pop()) {
        $cur = $kids[conflict.i];
        oldstruct = $oldkids[conflict.j];
        // attempt to determine if there was node rearrangement... won't gaurentee all matches
        // also handles case where added/removed nodes cause nodes to be identified as conflicts
        if (config.kids && counter && Math.abs(conflict.i - conflict.j) >= distance) {
          mutations.push(new MutationRecord({
            type: "childList",
            target: node,
            addedNodes: [$cur],
            removedNodes: [$cur],
            // haha don't rely on this please
            nextSibling: $cur.nextSibling,
            previousSibling: $cur.previousSibling
          }));
          counter--; // found conflict
        }
        // Alright we found the resorted nodes now check for other types of mutations
        if (config.attr && oldstruct.attr) _this.findAttributeMutations(mutations, $cur, oldstruct.attr, config.afilter);
        if (config.charData && $cur.nodeType === 3 && $cur.nodeValue !== oldstruct.charData) {
          mutations.push(new MutationRecord({
            type: "characterData",
            target: $cur,
            oldValue: oldstruct.charData
          }));
        }
        // now look @ subtree
        if (config.descendents) _findMutations($cur, oldstruct);
      }
    };
    /**
     * Main worker. Finds and adds mutations if there are any
     * @param {Node} node
     * @param {!Object} old : A cloned data structure using internal clone
     */
    var _findMutations = function (node, old) {
      var $kids = node.childNodes;
      var $oldkids = old.kids;
      var klen = $kids.length;
      // $oldkids will be undefined for text and comment nodes
      var olen = $oldkids ? $oldkids.length : 0;
      // if (!olen && !klen) return; // both empty; clearly no changes
      // we delay the intialization of these for marginal performance in the expected case (actually quite signficant on large subtrees when these would be otherwise unused)
      // map of checked element of ids to prevent registering the same conflict twice
      var map;
      // array of potential conflicts (ie nodes that may have been re arranged)
      var conflicts;
      var id; // element id from getElementId helper
      var idx; // index of a moved or inserted element
      var oldstruct;
      // current and old nodes
      var $cur;
      var $old;
      // track the number of added nodes so we can resolve conflicts more accurately
      var numAddedNodes = 0;
      // iterate over both old and current child nodes at the same time
      var i = 0;
      var j = 0;
      // while there is still anything left in $kids or $oldkids (same as i < $kids.length || j < $oldkids.length;)
      while (i < klen || j < olen) {
        // current and old nodes at the indexs
        $cur = $kids[i];
        oldstruct = $oldkids[j];
        $old = oldstruct && oldstruct.node;
        if ($cur === $old) {
          // expected case - optimized for this case
          // check attributes as specified by config
          if (config.attr && oldstruct.attr) {
            /* oldstruct.attr instead of textnode check */
            _this.findAttributeMutations(mutations, $cur, oldstruct.attr, config.afilter);
          }
          // check character data if node is a comment or textNode and it's being observed
          if (config.charData && oldstruct.charData !== undefined && $cur.nodeValue !== oldstruct.charData) {
            mutations.push(new MutationRecord({
              type: "characterData",
              target: $cur
            }));
          }
          // resolve conflicts; it will be undefined if there are no conflicts - otherwise an array
          if (conflicts) _resolveConflicts(conflicts, node, $kids, $oldkids, numAddedNodes);
          // recurse on next level of children. Avoids the recursive call when there are no children left to iterate
          if (config.descendents && ($cur.childNodes.length || oldstruct.kids && oldstruct.kids.length)) _findMutations($cur, oldstruct);
          i++;
          j++;
        } else {
          // (uncommon case) lookahead until they are the same again or the end of children
          dirty = true;
          if (!map) {
            // delayed initalization (big perf benefit)
            map = {};
            conflicts = [];
          }
          if ($cur) {
            // check id is in the location map otherwise do a indexOf search
            if (!map[id = Util.getElementId($cur)]) {
              // to prevent double checking
              // mark id as found
              map[id] = true;
              // custom indexOf using comparitor checking oldkids[i].node === $cur
              if ((idx = Util.indexOfCustomNode($oldkids, $cur, j)) === -1) {
                if (config.kids) {
                  mutations.push(new MutationRecord({
                    type: "childList",
                    target: node,
                    addedNodes: [$cur],
                    nextSibling: $cur.nextSibling,
                    previousSibling: $cur.previousSibling
                  }));
                  numAddedNodes++;
                }
              } else {
                conflicts.push({
                  i: i,
                  j: idx
                });
              }
            }
            i++;
          }
          if ($old &&
          // special case: the changes may have been resolved: i and j appear congurent so we can continue using the expected case
          $old !== $kids[i]) {
            if (!map[id = Util.getElementId($old)]) {
              map[id] = true;
              if ((idx = Util.indexOf($kids, $old, i)) === -1) {
                if (config.kids) {
                  mutations.push(new MutationRecord({
                    type: "childList",
                    target: old.node,
                    removedNodes: [$old],
                    nextSibling: $oldkids[j + 1],
                    previousSibling: $oldkids[j - 1]
                  }));
                  numAddedNodes--;
                }
              } else {
                conflicts.push({
                  i: idx,
                  j: j
                });
              }
            }
            j++;
          }
        } // end uncommon case
      } // end loop
      // resolve any remaining conflicts
      if (conflicts) _resolveConflicts(conflicts, node, $kids, $oldkids, numAddedNodes);
    };
    _findMutations($target, $oldstate);
    return dirty;
  };
  MutationObserver.prototype.findAttributeMutations = function (mutations, $target, $oldstate, filter) {
    var checked = {};
    var attributes = $target.attributes;
    var attr;
    var name;
    var i = attributes.length;
    while (i--) {
      attr = attributes[i];
      name = attr.name;
      if (!filter || Util.has(filter, name)) {
        if (attr.value !== $oldstate[name]) {
          // The pushing is redundant but gzips very nicely
          mutations.push(new MutationRecord({
            type: "attributes",
            target: $target,
            attributeName: name,
            oldValue: $oldstate[name],
            attributeNamespace: attr.namespaceURI // in ie<8 it incorrectly will return undefined
          }));
        }

        checked[name] = true;
      }
    }
    for (name in $oldstate) {
      if (!checked[name]) {
        mutations.push(new MutationRecord({
          target: $target,
          type: "attributes",
          attributeName: name,
          oldValue: $oldstate[name]
        }));
      }
    }
  };
  return MutationObserver;
}();
module.exports.MutationObserver = MutationObserver;
var MutationRecord = /** @class */function () {
  function MutationRecord(data) {
    var settings = {
      type: null,
      target: null,
      addedNodes: [],
      removedNodes: [],
      previousSibling: null,
      nextSibling: null,
      attributeName: null,
      attributeNamespace: null,
      oldValue: null
    };
    for (var prop in data) {
      if (Util.has(settings, prop) && data[prop] !== undefined) settings[prop] = data[prop];
    }
    return settings;
  }
  return MutationRecord;
}();
module.exports.MutationRecord = MutationRecord;
var MutationNotifier = /** @class */function (_super) {
  __extends(MutationNotifier, _super);
  function MutationNotifier() {
    var _this = _super.call(this) || this;
    _this.setMaxListeners(100);
    return _this;
  }
  MutationNotifier.getInstance = function () {
    if (!MutationNotifier._instance) {
      MutationNotifier._instance = new MutationNotifier();
    }
    return MutationNotifier._instance;
  };
  MutationNotifier.prototype.destruct = function () {
    this.removeAllListeners("changed");
  };
  MutationNotifier.prototype.notifyChanged = function (node) {
    this.emit("changed", node);
  };
  MutationNotifier._instance = null;
  return MutationNotifier;
}(_events.EventEmitter);
module.exports.MutationNotifier = MutationNotifier;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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