"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apiCallerMock = void 0;
Object.defineProperty(exports, "browserServicesMock", {
  enumerable: true,
  get: function () {
    return _browserServicesMock.default;
  }
});
Object.defineProperty(exports, "coreServicesMock", {
  enumerable: true,
  get: function () {
    return _coreServicesMock.default;
  }
});
Object.defineProperty(exports, "historyMock", {
  enumerable: true,
  get: function () {
    return _historyMock.default;
  }
});
Object.defineProperty(exports, "httpClientMock", {
  enumerable: true,
  get: function () {
    return _httpClientMock.default;
  }
});
Object.defineProperty(exports, "styleMock", {
  enumerable: true,
  get: function () {
    return _styleMock.default;
  }
});
var _browserServicesMock = _interopRequireDefault(require("./browserServicesMock"));
var _historyMock = _interopRequireDefault(require("./historyMock"));
var _httpClientMock = _interopRequireDefault(require("./httpClientMock"));
var _styleMock = _interopRequireDefault(require("./styleMock"));
var _coreServicesMock = _interopRequireDefault(require("./coreServicesMock"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const apiCallerMock = browserServicesMockObject => {
  browserServicesMockObject.commonService.apiCaller = jest.fn(async payload => {
    var _payload$data5, _payload$data6, _payload$data7;
    switch (payload.endpoint) {
      case "transport.request":
        {
          var _payload$data, _payload$data2, _payload$data3, _payload$data4;
          if ((_payload$data = payload.data) !== null && _payload$data !== void 0 && (_payload$data = _payload$data.path) !== null && _payload$data !== void 0 && _payload$data.startsWith("/_index_template/_simulate_index/bad_index")) {
            return {
              ok: true,
              response: {}
            };
          } else if ((_payload$data2 = payload.data) !== null && _payload$data2 !== void 0 && (_payload$data2 = _payload$data2.path) !== null && _payload$data2 !== void 0 && _payload$data2.startsWith("/_index_template/bad_template")) {
            return {
              ok: false,
              error: "bad template"
            };
          } else if ((_payload$data3 = payload.data) !== null && _payload$data3 !== void 0 && (_payload$data3 = _payload$data3.path) !== null && _payload$data3 !== void 0 && _payload$data3.startsWith("/_index_template/good_template")) {
            return {
              ok: true,
              response: {
                index_templates: [{
                  name: "good_template",
                  index_template: {}
                }]
              }
            };
          } else if ((_payload$data4 = payload.data) !== null && _payload$data4 !== void 0 && (_payload$data4 = _payload$data4.path) !== null && _payload$data4 !== void 0 && _payload$data4.startsWith("/_component_template/good_template")) {
            return {
              ok: true,
              response: {
                component_templates: [{
                  name: "good_template",
                  component_template: {
                    template: {}
                  }
                }]
              }
            };
          } else {
            return {
              ok: true,
              response: {
                template: {
                  settings: {
                    index: {
                      number_of_replicas: "10",
                      number_of_shards: "1"
                    }
                  }
                }
              }
            };
          }
        }
      case "indices.create":
        if (((_payload$data5 = payload.data) === null || _payload$data5 === void 0 ? void 0 : _payload$data5.index) === "bad_index") {
          return {
            ok: false,
            error: "bad_index"
          };
        }
        return {
          ok: true,
          response: {}
        };
        break;
      case "cat.aliases":
        return {
          ok: true,
          response: [{
            alias: ".kibana",
            index: ".kibana_1",
            filter: "-",
            is_write_index: "-"
          }, {
            alias: "2",
            index: "1234",
            filter: "-",
            is_write_index: "-"
          }]
        };
      case "indices.get":
        const payloadIndex = (_payload$data6 = payload.data) === null || _payload$data6 === void 0 ? void 0 : _payload$data6.index;
        if (payloadIndex === "bad_index") {
          return {
            ok: false,
            error: "bad_error",
            response: {}
          };
        }
        return {
          ok: true,
          response: {
            [(_payload$data7 = payload.data) === null || _payload$data7 === void 0 ? void 0 : _payload$data7.index]: {
              aliases: {
                update_test_1: {}
              },
              mappings: {
                properties: {
                  test_mapping_1: {
                    type: "text"
                  }
                }
              },
              settings: {
                "index.number_of_shards": "1",
                "index.number_of_replicas": "1"
              }
            }
          }
        };
    }
    return {
      ok: true,
      response: {}
    };
  });
};
exports.apiCallerMock = apiCallerMock;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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