"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const historyMock = {
  action: "REPLACE",
  // PUSH, REPLACE, POP
  block: jest.fn(),
  // prevents navigation
  createHref: jest.fn(),
  go: jest.fn(),
  // moves the pointer in the history stack by n entries
  goBack: jest.fn(),
  // equivalent to go(-1)
  goForward: jest.fn(),
  // equivalent to go(1)
  length: 0,
  // number of entries in the history stack
  listen: jest.fn(),
  location: {
    hash: "",
    // URL hash fragment
    pathname: "",
    // path of URL
    search: "",
    // URL query string
    state: undefined // location-specific state that was provided to e.g. push(path, state) when this location was pushed onto the stack
  },

  push: jest.fn(),
  // pushes new entry onto history stack
  replace: jest.fn() // replaces current entry on history stack
};
var _default = exports.default = historyMock;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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