"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const coreServicesMock = {
  uiSettings: {
    get: jest.fn()
  },
  chrome: {
    setBreadcrumbs: jest.fn()
  },
  notifications: {
    toasts: {
      addDanger: jest.fn(() => ({})).mockName("addDanger"),
      addSuccess: jest.fn(() => ({})).mockName("addSuccess"),
      addWarning: jest.fn(() => ({})).mockName("addWarning"),
      remove: jest.fn(() => ({})).mockName("remove")
    }
  },
  docLinks: {
    links: {
      opensearch: {
        reindexData: {
          base: "https://opensearch.org/docs/latest/opensearch/reindex-data/",
          transform: "https://opensearch.org/docs/latest/opensearch/reindex-data/#transform-documents-during-reindexing"
        },
        queryDSL: {
          base: "https://opensearch.org/docs/opensearch/query-dsl/index/"
        },
        indexTemplates: {
          base: "https://opensearch.org/docs/latest/opensearch/index-templates"
        },
        indexAlias: {
          base: "https://opensearch.org/docs/latest/opensearch/index-alias/"
        }
      }
    }
  }
};
var _default = exports.default = coreServicesMock;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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