"use strict";

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

module.exports = {
  rootDir: "../",
  setupFiles: ["<rootDir>/test/polyfills.ts", "<rootDir>/test/setupTests.ts"],
  setupFilesAfterEnv: ["<rootDir>/test/setup.jest.ts"],
  setupFilesAfterEnv: ["<rootDir>/test/setup.jest.ts", "<rootDir>../../src/dev/jest/setup/monaco_mock.js"],
  roots: ["<rootDir>"],
  coverageDirectory: "./coverage",
  moduleNameMapper: {
    "\\.(css|less|scss)$": "<rootDir>/test/mocks/styleMock.ts",
    "^ui/(.*)": "<rootDir>/../../src/legacy/ui/public/$1/"
  },
  coverageReporters: ["lcov", "text", "cobertura"],
  testMatch: ["**/*.test.js", "**/*.test.jsx", "**/*.test.ts", "**/*.test.tsx"],
  collectCoverageFrom: ["**/*.ts", "**/*.tsx", "**/*.js", "**/*.jsx", "!**/models/**", "!**/node_modules/**", "!**/index.ts", "!<rootDir>/index.js", "!<rootDir>/public/app.js", "!<rootDir>/public/temporary/**", "!<rootDir>/babel.config.js", "!<rootDir>/test/**", "!<rootDir>/server/**", "!<rootDir>/coverage/**", "!<rootDir>/scripts/**", "!<rootDir>/build/**", "!<rootDir>/cypress/**", "!**/vendor/**", "!**/index.d.ts", "!**/lib/field/**",
  // There is a compile error in monaco-editor, ignore related components
  "!**/components/JSONDiffEditor/**"],
  clearMocks: true,
  testPathIgnorePatterns: ["<rootDir>/build/", "<rootDir>/node_modules/"],
  modulePathIgnorePatterns: ["indexManagementDashboards"],
  testEnvironment: "jsdom"
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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