"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testTransformDisabled = exports.testTransform2 = exports.testTransform = exports.testRollup2 = exports.testRollup = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const testRollup = exports.testRollup = {
  _id: "test1",
  _version: 3,
  _seq_no: 7,
  _primary_term: 1,
  rollup: {
    rollup_id: "test1",
    enabled: true,
    schedule: {
      interval: {
        period: 1,
        unit: "Minutes",
        start_time: 1602100553
      }
    },
    last_updated_time: 1602100553,
    description: "An example job that rolls up the sample ecommerce data",
    source_index: "opensearch_dashboards_sample_data_ecommerce",
    target_index: "test_rollup",
    page_size: 1000,
    delay: 0,
    continuous: false,
    metadata_id: null,
    enabledTime: null,
    lastUpdatedTime: null,
    schemaVersion: 1,
    dimensions: [{
      date_histogram: {
        source_field: "order_date",
        fixed_interval: "90m",
        timezone: "America/Los_Angeles"
      }
    }, {
      terms: {
        source_field: "customer_gender"
      }
    }, {
      terms: {
        source_field: "geoip.city_name"
      }
    }, {
      terms: {
        source_field: "geoip.region_name"
      }
    }, {
      terms: {
        source_field: "day_of_week"
      }
    }],
    metrics: [{
      source_field: "taxless_total_price",
      metrics: [{
        avg: {}
      }, {
        sum: {}
      }, {
        max: {}
      }, {
        min: {}
      }, {
        value_count: {}
      }]
    }, {
      source_field: "total_quantity",
      metrics: [{
        avg: {}
      }, {
        max: {}
      }]
    }]
  },
  metadata: {
    test1: {
      metadata_id: "GSCm3HUBeGRB78cDQju6",
      rollup_metadata: {
        rollup_id: "test1",
        last_updated_time: 1605724690355,
        status: "finished",
        failure_reason: null,
        stats: {
          pages_processed: 5,
          documents_processed: 4675,
          rollups_indexed: 3627,
          index_time_in_millis: 1522,
          search_time_in_millis: 1168
        }
      }
    }
  }
};
const testRollup2 = exports.testRollup2 = {
  _id: "test2",
  _version: 3,
  _seq_no: 7,
  _primary_term: 1,
  rollup: {
    rollup_id: "test2",
    enabled: false,
    schedule: {
      interval: {
        period: 1,
        unit: "Minutes",
        start_time: 1602100553
      }
    },
    last_updated_time: 1602100553,
    description: "Another example job that rolls up the sample ecommerce data",
    source_index: "opensearch_dashboards_sample_data_ecommerce",
    target_index: "test_rollup2",
    page_size: 1000,
    delay: 0,
    continuous: false,
    dimensions: [{
      date_histogram: {
        source_field: "order_date",
        fixed_interval: "60m",
        timezone: "America/Los_Angeles"
      }
    }, {
      terms: {
        source_field: "customer_gender"
      }
    }, {
      terms: {
        source_field: "geoip.city_name"
      }
    }, {
      terms: {
        source_field: "geoip.region_name"
      }
    }, {
      terms: {
        source_field: "day_of_week"
      }
    }, {
      terms: {
        source_field: "day_of_week_i"
      }
    }],
    metrics: [{
      source_field: "taxless_total_price",
      metrics: [{
        avg: {}
      }, {
        sum: {}
      }, {
        max: {}
      }, {
        min: {}
      }, {
        value_count: {}
      }]
    }, {
      source_field: "total_quantity",
      metrics: [{
        avg: {}
      }, {
        max: {}
      }]
    }]
  },
  metadata: {
    test2: {
      metadata_id: "GSCm3HUBeGRB78cDQju6",
      rollup_metadata: {
        rollup_id: "test2",
        last_updated_time: 1605724690355,
        status: "failed",
        failure_reason: "Cannot create target index.",
        stats: {
          pages_processed: 0,
          documents_processed: 0,
          rollups_indexed: 0,
          index_time_in_millis: 0,
          search_time_in_millis: 0
        }
      }
    }
  }
};
const testTransform = exports.testTransform = {
  _id: "test1",
  _seqNo: 6,
  _primaryTerm: 1,
  transform: {
    transform_id: "test1",
    schema_version: 11,
    schedule: {
      interval: {
        start_time: 1632951884470,
        period: 1,
        unit: "Minutes"
      }
    },
    metadata_id: "tFttMG7OTAehIakVVsAA-g",
    updated_at: 1632951944840,
    enabled: false,
    enabled_at: null,
    description: "",
    source_index: "opensearch_dashboards_sample_data_ecommerce",
    data_selection_query: {
      match: {
        customer_gender: {
          query: "FEMALE",
          operator: "OR",
          prefix_length: 0,
          max_expansions: 50,
          fuzzy_transpositions: true,
          lenient: false,
          zero_terms_query: "NONE",
          auto_generate_synonyms_phrase_query: true,
          boost: 1
        }
      }
    },
    target_index: "t",
    page_size: 1000,
    groups: [{
      terms: {
        source_field: "currency",
        target_field: "currency_terms"
      }
    }],
    aggregations: {}
  },
  metadata: {
    test1: {
      metadata_id: "tFttMG7OTAehIakVVsAA-g",
      transform_metadata: {
        transform_id: "test1",
        last_updated_at: 1632951944827,
        status: "finished",
        failure_reason: null,
        stats: {
          pages_processed: 2,
          documents_processed: 2433,
          documents_indexed: 1,
          index_time_in_millis: 37,
          search_time_in_millis: 11
        }
      }
    }
  }
};
const testTransform2 = exports.testTransform2 = {
  _id: "test1",
  _version: 3,
  _seqNo: 7,
  _primaryTerm: 1,
  transform: {
    transform_id: "test1",
    enabled: true,
    schedule: {
      interval: {
        period: 1,
        unit: "Minutes",
        start_time: 1602100553
      }
    },
    metadata_id: null,
    updated_at: 1619725487957,
    enabled_at: 1619725487956,
    description: "Test transform using ecommerce data",
    source_index: "opensearch_dashboards_sample_data_ecommerce",
    target_index: "test_transform",
    data_selection_query: {
      match_all: {}
    },
    page_size: 1000,
    roles: [],
    groups: [{
      terms: {
        source_field: "customer_gender",
        target_field: "gender"
      }
    }, {
      terms: {
        source_field: "day_of_week",
        target_field: "day"
      }
    }],
    aggregations: {
      quantity: {
        sum: {
          field: "total_quantity"
        }
      }
    }
  },
  metadata: {
    test1: {
      metadata_id: "GSCm3HUBeGRB78cDQju6",
      transform_metadata: {
        transform_id: "test1",
        last_updated_time: 1605724690355,
        status: "finished",
        failure_reason: null,
        stats: {
          pages_processed: 5,
          documents_processed: 4675,
          transforms_indexed: 3627,
          index_time_in_millis: 1522,
          search_time_in_millis: 1168
        }
      }
    }
  }
};
const testTransformDisabled = exports.testTransformDisabled = {
  _id: "test1",
  _version: 3,
  _seq_no: 7,
  _primary_term: 1,
  transform: {
    transform_id: "test1",
    enabled: false,
    schedule: {
      interval: {
        period: 1,
        unit: "Minutes",
        start_time: 1602100553
      }
    },
    metadata_id: null,
    updated_at: 1619725487957,
    enabled_at: 1619725487956,
    description: "Test transform using ecommerce data",
    source_index: "opensearch_dashboards_sample_data_ecommerce",
    target_index: "test_transform",
    data_selection_query: {
      match_all: {}
    },
    page_size: 1000,
    roles: [],
    groups: [{
      terms: {
        source_field: "customer_gender",
        target_field: "gender"
      }
    }, {
      terms: {
        source_field: "day_of_week",
        target_field: "day"
      }
    }],
    aggregations: {
      quantity: {
        sum: {
          field: "total_quantity"
        }
      }
    }
  },
  metadata: {
    test1: {
      metadata_id: "GSCm3HUBeGRB78cDQju6",
      transform_metadata: {
        transform_id: "test1",
        last_updated_time: 1605724690355,
        status: "started",
        failure_reason: null,
        stats: {
          pages_processed: 5,
          documents_processed: 4675,
          transforms_indexed: 3627,
          index_time_in_millis: 1522,
          search_time_in_millis: 1168
        }
      }
    }
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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