"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMustQuery = getMustQuery;
exports.getSearchString = getSearchString;
exports.transformManagedIndexMetaData = transformManagedIndexMetaData;
var _lodash = _interopRequireDefault(require("lodash"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function transformManagedIndexMetaData(metaData) {
  if (!metaData) return null;
  // If this is not a managed index or we are still initializing we still return the
  // plugins.index_state_management.policy_id setting, but nothing else from the explain API
  if (!metaData.index) return null;
  return {
    index: metaData.index,
    // We know indexUuid and policyName exist if index exists
    indexUuid: metaData.index_uuid,
    policyId: metaData.policy_id,
    policySeqNo: metaData.policy_seq_no,
    policyPrimaryTerm: metaData.policy_primary_term,
    policyCompleted: metaData.policy_completed,
    rolledOver: metaData.rolled_over,
    transitionTo: metaData.transition_to,
    state: metaData.state ? {
      name: metaData.state.name,
      startTime: metaData.state.start_time
    } : undefined,
    action: metaData.action ? {
      name: metaData.action.name,
      startTime: metaData.action.start_time,
      index: metaData.action.index,
      failed: metaData.action.failed,
      consumedRetries: metaData.action.consumed_retries
    } : undefined,
    retryInfo: metaData.retry_info ? {
      failed: metaData.retry_info.failed,
      consumedRetries: metaData.retry_info.consumed_retries
    } : undefined,
    info: metaData.info
  };
}
function getMustQuery(field, search) {
  const str = search.trim();
  if (search.trim()) {
    return {
      query_string: {
        default_field: field,
        default_operator: "AND",
        query: str ? `*${str.split(" ").join("* *")}*` : "*"
      }
    };
  }
  return {
    match_all: {}
  };
}
function getSearchString(terms, indices, dataStreams, showDataStreams = true) {
  // Terms are searched with a wildcard around them.
  const searchTerms = terms ? `*${_lodash.default.castArray(terms).join("*,*")}*` : "";

  // Indices and data streams are searched with wildcards around them.
  const searchIndices = indices ? `*${_lodash.default.castArray(indices).join("*,*")}*` : "";
  const searchDataStreams = dataStreams ? `*${_lodash.default.castArray(dataStreams).join("*,*")}*` : "";

  // The overall search string is a combination of terms, indices, and data streams.
  // If the search string is blank, then '*' is used to match everything.
  const resolved = [searchTerms, searchIndices, searchDataStreams].filter(value => value !== "").join(",") || "*";
  // We don't want to fetch managed datastream indices if there are not selected by caller.
  return showDataStreams ? resolved : resolved + " -.ds*";
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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