"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRANSFORM_ROUTE_PREFIX = exports.Setting = exports.SM_ROUTE_PREFIX = exports.SECURITY_EXCEPTION_PREFIX = exports.NOTIFICATION_CONFIGS_ROUTE = exports.NOTIFICATIONS_API_ROUTE_PREFIX = exports.INDEX = exports.DEFAULT_HEADERS = exports.CLUSTER = exports.CHANNELS_ROUTE = exports.API_ROUTE_PREFIX_ROLLUP = exports.API_ROUTE_PREFIX = exports.API = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const API_ROUTE_PREFIX = exports.API_ROUTE_PREFIX = "/_plugins/_ism";
const API_ROUTE_PREFIX_ROLLUP = exports.API_ROUTE_PREFIX_ROLLUP = "/_plugins/_rollup";
const TRANSFORM_ROUTE_PREFIX = exports.TRANSFORM_ROUTE_PREFIX = "/_plugins/_transform";
const NOTIFICATIONS_API_ROUTE_PREFIX = exports.NOTIFICATIONS_API_ROUTE_PREFIX = "/_plugins/_notifications";
const CHANNELS_ROUTE = exports.CHANNELS_ROUTE = `${NOTIFICATIONS_API_ROUTE_PREFIX}/channels`;
const NOTIFICATION_CONFIGS_ROUTE = exports.NOTIFICATION_CONFIGS_ROUTE = `${NOTIFICATIONS_API_ROUTE_PREFIX}/configs`;
const SM_ROUTE_PREFIX = exports.SM_ROUTE_PREFIX = "/_plugins/_sm";
const API = exports.API = {
  POLICY_BASE: `${API_ROUTE_PREFIX}/policies`,
  EXPLAIN_BASE: `${API_ROUTE_PREFIX}/explain`,
  RETRY_BASE: `${API_ROUTE_PREFIX}/retry`,
  ADD_POLICY_BASE: `${API_ROUTE_PREFIX}/add`,
  REMOVE_POLICY_BASE: `${API_ROUTE_PREFIX}/remove`,
  CHANGE_POLICY_BASE: `${API_ROUTE_PREFIX}/change_policy`,
  ROLLUP_JOBS_BASE: `${API_ROUTE_PREFIX_ROLLUP}/jobs`,
  TRANSFORM_BASE: `${TRANSFORM_ROUTE_PREFIX}`,
  CHANNELS_BASE: `${CHANNELS_ROUTE}`,
  NOTIFICATION_CONFIGS_BASE: `${NOTIFICATION_CONFIGS_ROUTE}`,
  SM_POLICY_BASE: `${SM_ROUTE_PREFIX}/policies`
};
const DEFAULT_HEADERS = exports.DEFAULT_HEADERS = {
  "Content-Type": "application/json",
  Accept: "application/json"
};
let CLUSTER = exports.CLUSTER = /*#__PURE__*/function (CLUSTER) {
  CLUSTER["ADMIN"] = "admin";
  CLUSTER["ISM"] = "opendistro_ism";
  CLUSTER["DATA"] = "data";
  return CLUSTER;
}({});
let INDEX = exports.INDEX = /*#__PURE__*/function (INDEX) {
  INDEX["OPENDISTRO_ISM_CONFIG"] = ".opendistro-ism-config";
  return INDEX;
}({});
let Setting = exports.Setting = /*#__PURE__*/function (Setting) {
  Setting["RolloverAlias"] = "plugins.index_state_management.rollover_alias";
  return Setting;
}({});
const SECURITY_EXCEPTION_PREFIX = exports.SECURITY_EXCEPTION_PREFIX = "[security_exception]";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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