"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class TransformService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getTransforms", async (context, request, response) => {
      try {
        const {
          from,
          size,
          search,
          sortDirection,
          sortField
        } = request.query;
        const transformSortMap = {
          _id: "transform.transform_id.keyword",
          "transform.source_index": "transform.source_index.keyword",
          "transform.target_index": "transform.target_index.keyword",
          "transform.transform.enabled": "transform.enabled"
        };
        const params = {
          from: parseInt(from, 10),
          size: parseInt(size, 10),
          search,
          sortField: transformSortMap[sortField] || transformSortMap._id,
          sortDirection
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const getTransformsResponse = await callWithRequest("ism.getTransforms", params);
        const totalTransforms = getTransformsResponse.total_transforms;
        const transforms = getTransformsResponse.transforms.map(transform => ({
          _seqNo: transform._seqNo,
          _primaryTerm: transform._primaryTerm,
          _id: transform._id,
          transform: transform.transform,
          metadata: null
        }));
        if (totalTransforms) {
          const ids = transforms.map(transform => transform._id).join(",");
          const callWithRequest = this.getClientBasedOnDataSource(context, request);
          const explainResponse = await callWithRequest("ism.explainTransform", {
            transformId: ids
          });
          if (!explainResponse.error) {
            transforms.map(transform => {
              transform.metadata = explainResponse[transform._id];
            });
            return response.custom({
              statusCode: 200,
              body: {
                ok: true,
                response: {
                  transforms: transforms,
                  totalTransforms: totalTransforms,
                  metadata: explainResponse
                }
              }
            });
          } else {
            return response.custom({
              statusCode: 200,
              body: {
                ok: false,
                error: explainResponse ? explainResponse.error : "An error occurred when calling getExplain API."
              }
            });
          }
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              transforms: transforms,
              totalTransforms: totalTransforms,
              metadata: {}
            }
          }
        });
      } catch (err) {
        if (err.statusCode === 404 && err.body.error.type === "index_not_found_exception") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: {
                transforms: [],
                totalTransforms: 0,
                metadata: null
              }
            }
          });
        }
        console.error("Index Management - TransformService - getTransforms", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: "Error in getTransforms" + err.message
          }
        });
      }
    });
    _defineProperty(this, "getTransform", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          transformId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const getResponse = await callWithRequest("ism.getTransform", params);
        const metadata = await callWithRequest("ism.explainTransform", params);
        const transform = _lodash.default.get(getResponse, "transform", null);
        const seqNo = _lodash.default.get(getResponse, "_seq_no", null);
        const primaryTerm = _lodash.default.get(getResponse, "_primary_term", null);
        if (transform) {
          if (metadata) {
            return response.custom({
              statusCode: 200,
              body: {
                ok: true,
                response: {
                  _id: id,
                  _seqNo: seqNo,
                  _primaryTerm: primaryTerm,
                  transform: transform,
                  metadata: metadata
                }
              }
            });
          } else {
            return response.custom({
              statusCode: 200,
              body: {
                ok: false,
                error: "Failed to load metadata for transform"
              }
            });
          }
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to load transform"
            }
          });
        }
      } catch (err) {
        console.error("Index Management - TransformService - getTransform:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "startTransform", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          transformId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const startResponse = await callWithRequest("ism.startTransform", params);
        const acknowledged = _lodash.default.get(startResponse, "acknowledged");
        if (acknowledged) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: true
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to start transform"
            }
          });
        }
      } catch (err) {
        console.error("Index Management - TransformService - startTransform", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "stopTransform", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          transformId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const stopResponse = await callWithRequest("ism.stopTransform", params);
        const acknowledged = _lodash.default.get(stopResponse, "acknowledged");
        if (acknowledged) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: true
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to stop transform"
            }
          });
        }
      } catch (err) {
        console.error("Index Management - TransformService - stopTransform", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "deleteTransform", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          transformId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const deleteResponse = await callWithRequest("ism.deleteTransform", params);
        if (!deleteResponse.errors) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: true
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to delete transform"
            }
          });
        }
      } catch (err) {
        console.error("Index Management - TransformService - deleteTransform", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "putTransform", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          seqNo,
          primaryTerm
        } = request.query;
        let method = "ism.putTransform";
        let params = {
          transformId: id,
          if_seq_no: seqNo,
          if_primary_term: primaryTerm,
          body: JSON.stringify(request.body)
        };
        if (seqNo === undefined || primaryTerm === undefined) {
          method = "ism.putTransform";
          params = {
            transformId: id,
            body: JSON.stringify(request.body)
          };
        }
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const putTransformResponse = await callWithRequest(method, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: putTransformResponse
          }
        });
      } catch (err) {
        console.error("Index Management - TransformService - putTransform", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "searchSampleData", async (context, request, response) => {
      try {
        const {
          from,
          size
        } = request.query;
        const {
          index
        } = request.params;
        let params = {
          index: index,
          from: from,
          size: size,
          body: request.body ? JSON.stringify({
            query: request.body
          }) : {}
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const searchResponse = await callWithRequest("search", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              total: searchResponse.hits.total,
              data: searchResponse.hits.hits
            }
          }
        });
      } catch (err) {
        var _err$body;
        if (err.statusCode === 404 && ((_err$body = err.body) === null || _err$body === void 0 || (_err$body = _err$body.error) === null || _err$body === void 0 ? void 0 : _err$body.type) === "index_not_found_exception") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: {
                total: 0,
                data: []
              }
            }
          });
        }
        console.error("Index Management - TransformService - searchSampleData", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "previewTransform", async (context, request, response) => {
      try {
        let params = {
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const previewResponse = await callWithRequest("ism.previewTransform", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: previewResponse
          }
        });
      } catch (err) {
        console.error("Index Management - TransformService - previewTransform", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
  }
}
exports.default = TransformService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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