"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class SnapshotManagementService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getAllSnapshotsWithPolicy", async (context, request, response) => {
      try {
        var _getRepositoryRes$pay;
        // if no repository input, we need to first get back all repositories
        const getRepositoryRes = await this.catRepositories(context, request, response);
        let repositories;
        if ((_getRepositoryRes$pay = getRepositoryRes.payload) !== null && _getRepositoryRes$pay !== void 0 && _getRepositoryRes$pay.ok) {
          var _getRepositoryRes$pay2;
          repositories = (_getRepositoryRes$pay2 = getRepositoryRes.payload) === null || _getRepositoryRes$pay2 === void 0 ? void 0 : _getRepositoryRes$pay2.response.map(repo => repo.id);
        } else {
          var _getRepositoryRes$pay3;
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: (_getRepositoryRes$pay3 = getRepositoryRes.payload) === null || _getRepositoryRes$pay3 === void 0 ? void 0 : _getRepositoryRes$pay3.error
            }
          });
        }
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        let snapshots = [];
        for (let i = 0; i < repositories.length; i++) {
          const res = await callWithRequest("snapshot.get", {
            repository: repositories[i],
            snapshot: "_all",
            ignore_unavailable: true
          });
          const snapshotWithPolicy = res.snapshots.map(s => {
            var _s$metadata;
            return {
              id: s.snapshot,
              status: s.state,
              start_epoch: s.start_time_in_millis,
              end_epoch: s.end_time_in_millis,
              duration: s.duration_in_millis,
              indices: s.indices.length,
              successful_shards: s.shards.successful,
              failed_shards: s.shards.failed,
              total_shards: s.shards.total,
              repository: repositories[i],
              policy: (_s$metadata = s.metadata) === null || _s$metadata === void 0 ? void 0 : _s$metadata.sm_policy
            };
          });
          snapshots = [...snapshots, ...snapshotWithPolicy];
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              snapshots: snapshots,
              totalSnapshots: snapshots.length
            }
          }
        });
      } catch (err) {
        // If getting a non-existing snapshot, need to handle the missing snapshot exception, and return empty
        return this.errorResponse(response, err, "getAllSnapshotsWithPolicy");
      }
    });
    _defineProperty(this, "getSnapshot", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          repository
        } = request.query;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("snapshot.get", {
          repository: repository,
          snapshot: `${id}`,
          ignore_unavailable: true
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res.snapshots[0]
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "getSnapshot");
      }
    });
    _defineProperty(this, "deleteSnapshot", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          repository
        } = request.query;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const resp = await callWithRequest("snapshot.delete", {
          repository: repository,
          snapshot: `${id}`
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: resp
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "deleteSnapshot");
      }
    });
    _defineProperty(this, "createSnapshot", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          repository
        } = request.query;
        const params = {
          repository: repository,
          snapshot: id,
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const resp = await callWithRequest("snapshot.create", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: resp
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "createSnapshot");
      }
    });
    _defineProperty(this, "restoreSnapshot", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          repository
        } = request.query;
        const params = {
          repository: repository,
          snapshot: id,
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const resp = await callWithRequest("snapshot.restore", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: resp
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "restoreSnapshot");
      }
    });
    _defineProperty(this, "createPolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          policyId: id,
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const rawRes = await callWithRequest("ism.createSMPolicy", params);
        const res = {
          seqNo: rawRes._seq_no,
          primaryTerm: rawRes._primary_term,
          id: rawRes._id,
          policy: rawRes.sm_policy
        };
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "createPolicy");
      }
    });
    _defineProperty(this, "updatePolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          seqNo,
          primaryTerm
        } = request.query;
        const params = {
          policyId: id,
          ifSeqNo: seqNo,
          ifPrimaryTerm: primaryTerm,
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const rawRes = await callWithRequest("ism.updateSMPolicy", params);
        const res = {
          seqNo: rawRes._seq_no,
          primaryTerm: rawRes._primary_term,
          id: rawRes._id,
          policy: rawRes.sm_policy
        };
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "updatePolicy");
      }
    });
    _defineProperty(this, "getPolicies", async (context, request, response) => {
      try {
        const {
          from,
          size,
          sortField,
          sortOrder,
          queryString
        } = request.query;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        let params = {
          from,
          size,
          sortField: `sm_policy.${sortField}`,
          sortOrder,
          queryString: queryString.trim() ? `${queryString.trim()}` : "*"
        };
        const res = await callWithRequest("ism.getSMPolicies", params);
        const policies = res.policies.map(p => ({
          seqNo: p._seq_no,
          primaryTerm: p._primary_term,
          id: p._id,
          policy: p.sm_policy
        }));
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              policies,
              totalPolicies: res.total_policies
            }
          }
        });
      } catch (err) {
        if (err.statusCode === 404 && err.body.error.reason === "Snapshot management config index not found") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: {
                policies: [],
                totalPolicies: 0
              }
            }
          });
        }
        return this.errorResponse(response, err, "getPolicies");
      }
    });
    _defineProperty(this, "getPolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          id: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const getResponse = await callWithRequest("ism.getSMPolicy", params);
        const metadata = await callWithRequest("ism.explainSnapshotPolicy", params);
        const documentPolicy = {
          id: id,
          seqNo: getResponse._seq_no,
          primaryTerm: getResponse._primary_term,
          policy: getResponse.sm_policy,
          metadata: metadata.policies[0]
        };
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: documentPolicy
          }
        });
      } catch (err) {
        if (err.statusCode === 404 && err.body.error.reason === "Snapshot management config index not found") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: null
            }
          });
        }
        return this.errorResponse(response, err, "getPolicy");
      }
    });
    _defineProperty(this, "deletePolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          policyId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const deletePolicyResponse = await callWithRequest("ism.deleteSMPolicy", params);
        if (deletePolicyResponse.result !== "deleted") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: deletePolicyResponse.result
            }
          });
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: true
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "deletePolicy");
      }
    });
    _defineProperty(this, "startPolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          id: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const resp = await callWithRequest("ism.startSnapshotPolicy", params);
        if (resp.acknowledged) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: true
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to start snapshot policy."
            }
          });
        }
      } catch (err) {
        return this.errorResponse(response, err, "startPolicy");
      }
    });
    _defineProperty(this, "stopPolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          id: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const resp = await callWithRequest("ism.stopSnapshotPolicy", params);
        if (resp.acknowledged) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: true
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to stop snapshot policy."
            }
          });
        }
      } catch (err) {
        return this.errorResponse(response, err, "stopPolicy");
      }
    });
    _defineProperty(this, "catRepositories", async (context, request, response) => {
      try {
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("cat.repositories", {
          format: "json"
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "catRepositories");
      }
    });
    _defineProperty(this, "getIndexRecovery", async (context, request, response) => {
      try {
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("indices.recovery", {
          format: "json"
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "getIndexRecovery");
      }
    });
    _defineProperty(this, "catSnapshotIndices", async (context, request, response) => {
      try {
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("cat.indices", {
          format: "json"
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "catSnapshotIndices");
      }
    });
    _defineProperty(this, "catRepositoriesWithSnapshotCount", async (context, request, response) => {
      try {
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("cat.repositories", {
          format: "json"
        });
        for (let i = 0; i < res.length; i++) {
          let catSnapshotResponse = await this._safecatSnapshotForRepo(callWithRequest, res[i].id);
          res[i].snapshotCount = catSnapshotResponse === null || catSnapshotResponse === void 0 ? void 0 : catSnapshotResponse.length;
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "catRepositoriesWithSnapshotCount");
      }
    });
    _defineProperty(this, "deleteRepository", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("snapshot.deleteRepository", {
          repository: id
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "deleteRepository");
      }
    });
    _defineProperty(this, "getRepository", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("snapshot.getRepository", {
          repository: id
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "getRepository");
      }
    });
    _defineProperty(this, "createRepository", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          repository: id,
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("snapshot.createRepository", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "createRepository");
      }
    });
    _defineProperty(this, "errorResponse", (response, error, methodName) => {
      console.error(`Index Management - SnapshotManagementService - ${methodName}:`, error);
      return response.custom({
        statusCode: 200,
        // error?.statusCode || 500,
        body: {
          ok: false,
          error: this.parseEsErrorResponse(error)
        }
      });
    });
    _defineProperty(this, "parseEsErrorResponse", error => {
      if (error.response) {
        try {
          const esErrorResponse = JSON.parse(error.response);
          return esErrorResponse.reason || error.response;
        } catch (parsingError) {
          return error.response;
        }
      }
      return error.message;
    });
  }
  async _safecatSnapshotForRepo(callWithRequest, repositoryName) {
    try {
      const catSnapshotRes = await callWithRequest("cat.snapshots", {
        format: "json",
        repository: repositoryName,
        ignore_unavailable: true
      });
      return catSnapshotRes;
    } catch (err) {
      console.error(`Index Management - SnapshotManagementService - _safeCatSnapshot:`, err);
      return undefined;
    }
  }
}
exports.default = SnapshotManagementService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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