"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class RollupService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    /**
     * Calls backend Put Rollup API
     */
    _defineProperty(this, "putRollup", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          seqNo,
          primaryTerm
        } = request.query;
        let method = "ism.putRollup";
        let params = {
          rollupId: id,
          if_seq_no: seqNo,
          if_primary_term: primaryTerm,
          body: JSON.stringify(request.body)
        };
        if (seqNo === undefined || primaryTerm === undefined) {
          method = "ism.createRollup";
          params = {
            rollupId: id,
            body: JSON.stringify(request.body)
          };
        }
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const putRollupResponse = await callWithRequest(method, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: putRollupResponse
          }
        });
      } catch (err) {
        console.error("Index Management - RollupService - putRollup", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    /**
     * Calls backend Delete Rollup API
     */
    _defineProperty(this, "deleteRollup", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          rollupId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const deleteRollupResponse = await callWithRequest("ism.deleteRollup", params);
        if (deleteRollupResponse.result !== "deleted") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: deleteRollupResponse.result
            }
          });
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: true
          }
        });
      } catch (err) {
        console.error("Index Management - RollupService - deleteRollup:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "startRollup", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          rollupId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const startResponse = await callWithRequest("ism.startRollup", params);
        const acknowledged = _lodash.default.get(startResponse, "acknowledged");
        if (acknowledged) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: true
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to start rollup"
            }
          });
        }
      } catch (err) {
        console.error("Index Management - RollupService - startRollup:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "stopRollup", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          rollupId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const stopResponse = await callWithRequest("ism.stopRollup", params);
        const acknowledged = _lodash.default.get(stopResponse, "acknowledged");
        if (acknowledged) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: true
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to stop rollup"
            }
          });
        }
      } catch (err) {
        console.error("Index Management - RollupService - stopRollup:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    /**
     * Calls backend Get Rollup API
     */
    _defineProperty(this, "getRollup", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          rollupId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const getResponse = await callWithRequest("ism.getRollup", params);
        const metadata = await callWithRequest("ism.explainRollup", params);
        const rollup = _lodash.default.get(getResponse, "rollup", null);
        const seqNo = _lodash.default.get(getResponse, "_seq_no");
        const primaryTerm = _lodash.default.get(getResponse, "_primary_term");

        //Form response
        if (rollup) {
          if (metadata) {
            return response.custom({
              statusCode: 200,
              body: {
                ok: true,
                response: {
                  _id: id,
                  _seqNo: seqNo,
                  _primaryTerm: primaryTerm,
                  rollup: rollup,
                  metadata: metadata
                }
              }
            });
          } else return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to load metadata"
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to load rollup"
            }
          });
        }
      } catch (err) {
        console.error("Index Management - RollupService - getRollup:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "getMappings", async (context, request, response) => {
      try {
        const {
          index
        } = request.body;
        const params = {
          index: index
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const mappings = await callWithRequest("indices.getMapping", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: mappings
          }
        });
      } catch (err) {
        console.error("Index Management - RollupService - getMapping:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    /**
     * Performs a fuzzy search request on rollup id
     */
    _defineProperty(this, "getRollups", async (context, request, response) => {
      try {
        const {
          from,
          size,
          search,
          sortDirection,
          sortField
        } = request.query;
        const rollupSortMap = {
          _id: "rollup.rollup_id.keyword",
          "rollup.source_index": "rollup.source_index.keyword",
          "rollup.target_index": "rollup.target_index.keyword",
          "rollup.rollup.enabled": "rollup.enabled"
        };
        const params = {
          from: parseInt(from, 10),
          size: parseInt(size, 10),
          search,
          sortField: rollupSortMap[sortField] || rollupSortMap._id,
          sortDirection
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const getRollupResponse = await callWithRequest("ism.getRollups", params);
        const totalRollups = getRollupResponse.total_rollups;
        const rollups = getRollupResponse.rollups.map(rollup => ({
          _seqNo: rollup._seqNo,
          _primaryTerm: rollup._primaryTerm,
          _id: rollup._id,
          rollup: rollup.rollup,
          metadata: null
        }));

        // Call getExplain if any rollup job exists
        if (totalRollups) {
          // Concat rollup job ids
          const ids = rollups.map(rollup => rollup._id).join(",");
          const explainResponse = await callWithRequest("ism.explainRollup", {
            rollupId: ids
          });
          if (!explainResponse.error) {
            rollups.map(rollup => {
              rollup.metadata = explainResponse[rollup._id];
            });
            return response.custom({
              statusCode: 200,
              body: {
                ok: true,
                response: {
                  rollups: rollups,
                  totalRollups: totalRollups,
                  metadata: explainResponse
                }
              }
            });
          } else return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: explainResponse ? explainResponse.error : "An error occurred when calling getExplain API."
            }
          });
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              rollups: rollups,
              totalRollups: totalRollups,
              metadata: {}
            }
          }
        });
      } catch (err) {
        if (err.statusCode === 404 && err.body.error.type === "index_not_found_exception") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: {
                rollups: [],
                totalRollups: 0,
                metadata: null
              }
            }
          });
        }
        console.error("Index Management - RollupService - getRollups", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: "Error in getRollups " + err.message
          }
        });
      }
    });
  }
}
exports.default = RollupService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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