"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class PolicyService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    /**
     * Calls backend Put Policy API
     */
    _defineProperty(this, "putPolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          seqNo,
          primaryTerm
        } = request.query;
        let method = "ism.putPolicy";
        let params = {
          policyId: id,
          ifSeqNo: seqNo,
          ifPrimaryTerm: primaryTerm,
          body: JSON.stringify(request.body)
        };
        if (seqNo === undefined || primaryTerm === undefined) {
          method = "ism.createPolicy";
          params = {
            policyId: id,
            body: JSON.stringify(request.body)
          };
        }
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const putPolicyResponse = await callWithRequest(method, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: putPolicyResponse
          }
        });
      } catch (err) {
        console.error("Index Management - PolicyService - putPolicy:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    /**
     * Calls backend Delete Policy API
     */
    _defineProperty(this, "deletePolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          policyId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const deletePolicyResponse = await callWithRequest("ism.deletePolicy", params);
        if (deletePolicyResponse.result !== "deleted") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: deletePolicyResponse.result
            }
          });
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: true
          }
        });
      } catch (err) {
        console.error("Index Management - PolicyService - deletePolicy:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    /**
     * Calls backend Get Policy API
     */
    _defineProperty(this, "getPolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          policyId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const getResponse = await callWithRequest("ism.getPolicy", params);
        const policy = _lodash.default.get(getResponse, "policy", null);
        const seqNo = _lodash.default.get(getResponse, "_seq_no");
        const primaryTerm = _lodash.default.get(getResponse, "_primary_term");
        if (policy) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: {
                id,
                seqNo: seqNo,
                primaryTerm: primaryTerm,
                policy: policy
              }
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to load policy"
            }
          });
        }
      } catch (err) {
        console.error("Index Management - PolicyService - getPolicy:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "getPolicies", async (context, request, response) => {
      try {
        const {
          from = 0,
          size = 20,
          search,
          sortDirection = "desc",
          sortField = "id"
        } = request.query;
        const policySorts = {
          id: "policy.policy_id.keyword",
          "policy.policy.description": "policy.description.keyword",
          "policy.policy.last_updated_time": "policy.last_updated_time"
        };
        const params = {
          from,
          size,
          sortOrder: sortDirection,
          sortField: policySorts[sortField] || policySorts.id,
          queryString: search.trim() ? `*${search.trim().split(" ").join("* *")}*` : "*"
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const getResponse = await callWithRequest("ism.getPolicies", params);
        const policies = getResponse.policies.map(p => ({
          seqNo: p._seq_no,
          primaryTerm: p._primary_term,
          id: p._id,
          policy: p.policy
        }));
        const totalPolicies = getResponse.total_policies;
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              policies: policies,
              totalPolicies
            }
          }
        });
      } catch (err) {
        if (err.statusCode === 404 && err.body.error.type === "index_not_found_exception") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: {
                policies: [],
                totalPolicies: 0
              }
            }
          });
        }
        console.error("Index Management - PolicyService - getPolicies", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
  }
}
exports.default = PolicyService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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