"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class NotificationService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getChannels", async (context, request, response) => {
      try {
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const getChannelsResponse = await callWithRequest("ism.getChannels", {});
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getChannelsResponse
          }
        });
      } catch (err) {
        console.error("Index Management - NotificationService - getChannels:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "getChannelById", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const getResponse = await callWithRequest("ism.getChannel", {
          id
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getResponse
          }
        });
      } catch (err) {
        console.error("Index Management - NotificationService - getChannel:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
  }
}
exports.default = NotificationService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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