"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _constants = require("../utils/constants");
var _helpers = require("../utils/helpers");
var _DataStreamService = require("./DataStreamService");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class ManagedIndexService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    // TODO: Not finished, need UI page that uses this first
    _defineProperty(this, "getManagedIndex", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          id,
          index: _constants.INDEX.OPENDISTRO_ISM_CONFIG
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const results = await callWithRequest("search", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: results
          }
        });
      } catch (err) {
        console.error("Index Management - ManagedIndexService - getManagedIndex:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "getManagedIndices", async (context, request, response) => {
      try {
        const {
          from,
          size,
          sortDirection,
          sortField,
          terms,
          indices,
          dataStreams,
          showDataStreams
        } = request.query;
        const managedIndexSorts = {
          index: "managed_index.index",
          policyId: "managed_index.policy_id"
        };
        const explainParams = {
          sortField: sortField ? managedIndexSorts[sortField] : null,
          sortOrder: sortDirection,
          queryString: (0, _helpers.getSearchString)(terms, indices, dataStreams, showDataStreams),
          from: from,
          size: size
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const [explainAllResponse, indexToDataStreamMapping] = await Promise.all([callWithRequest("ism.explainAll", explainParams), (0, _DataStreamService.getIndexToDataStreamMapping)(callWithRequest)]);
        const managedIndices = [];
        for (const indexName in explainAllResponse) {
          if (indexName == "total_managed_indices") continue;
          const metadata = explainAllResponse[indexName];

          // If showDataStreams is not true, then skip the managed index if it belongs to a data stream.
          const parentDataStream = indexToDataStreamMapping[metadata.index] || null;
          if (!showDataStreams && parentDataStream !== null) continue;
          let policy, seqNo, primaryTerm, getResponse;
          try {
            getResponse = await callWithRequest("ism.getPolicy", {
              policyId: metadata.policy_id
            });
          } catch (err) {
            if (err.statusCode === 404 && err.body.error.reason === "Policy not found") {
              console.log("managed index with not existing policy");
            } else {
              throw err;
            }
          }
          policy = _lodash.default.get(getResponse, "policy", null);
          seqNo = _lodash.default.get(getResponse, "_seq_no", null);
          primaryTerm = _lodash.default.get(getResponse, "_primary_term", null);
          managedIndices.push({
            index: metadata.index,
            indexUuid: metadata.index_uuid,
            dataStream: parentDataStream,
            policyId: metadata.policy_id,
            policySeqNo: seqNo,
            policyPrimaryTerm: primaryTerm,
            policy: policy,
            enabled: metadata.enabled,
            managedIndexMetaData: (0, _helpers.transformManagedIndexMetaData)(metadata)
          });
        }
        let totalManagedIndices = explainAllResponse.total_managed_indices;
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              managedIndices: managedIndices,
              totalManagedIndices: totalManagedIndices
            }
          }
        });
      } catch (err) {
        if (err.statusCode === 404 && err.body.error.type === "index_not_found_exception") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: {
                managedIndices: [],
                totalManagedIndices: 0
              }
            }
          });
        }
        console.error("Index Management - ManagedIndexService - getManagedIndices", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "retryManagedIndexPolicy", async (context, request, response) => {
      try {
        const {
          index,
          state = null
        } = request.body;
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const params = {
          index: index.join(",")
        };
        if (state) params.body = {
          state
        };
        const retryResponse = await callWithRequest("ism.retry", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              failures: retryResponse.failures,
              updatedIndices: retryResponse.updated_indices,
              // TODO: remove ternary after fixing retry API to return empty array even if no failures
              failedIndices: retryResponse.failed_indices ? retryResponse.failed_indices.map(failedIndex => ({
                indexName: failedIndex.index_name,
                indexUuid: failedIndex.index_uuid,
                reason: failedIndex.reason
              })) : []
            }
          }
        });
      } catch (err) {
        console.error("Index Management - ManagedIndexService - retryManagedIndexPolicy:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "changePolicy", async (context, request, response) => {
      try {
        const {
          indices,
          policyId,
          include,
          state
        } = request.body;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const params = {
          index: indices.join(","),
          body: {
            policy_id: policyId,
            include,
            state
          }
        };
        const changeResponse = await callWithRequest("ism.change", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              failures: changeResponse.failures,
              updatedIndices: changeResponse.updated_indices,
              failedIndices: changeResponse.failed_indices.map(failedIndex => ({
                indexName: failedIndex.index_name,
                indexUuid: failedIndex.index_uuid,
                reason: failedIndex.reason
              }))
            }
          }
        });
      } catch (err) {
        console.error("Index Management - ManagedIndexService - changePolicy:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "removePolicy", async (context, request, response) => {
      try {
        const {
          indices
        } = request.body;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const params = {
          index: indices.join(",")
        };
        const addResponse = await callWithRequest("ism.remove", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              failures: addResponse.failures,
              updatedIndices: addResponse.updated_indices,
              failedIndices: addResponse.failed_indices.map(failedIndex => ({
                indexName: failedIndex.index_name,
                indexUuid: failedIndex.index_uuid,
                reason: failedIndex.reason
              }))
            }
          }
        });
      } catch (err) {
        console.error("Index Management - ManagedIndexService - removePolicy:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
  }
}
exports.default = ManagedIndexService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfbG9kYXNoIiwiX2ludGVyb3BSZXF1aXJlRGVmYXVsdCIsInJlcXVpcmUiLCJfY29uc3RhbnRzIiwiX2hlbHBlcnMiLCJfRGF0YVN0cmVhbVNlcnZpY2UiLCJfTURTRW5hYmxlZENsaWVudFNlcnZpY2UiLCJlIiwiX19lc01vZHVsZSIsImRlZmF1bHQiLCJfZGVmaW5lUHJvcGVydHkiLCJyIiwidCIsIl90b1Byb3BlcnR5S2V5IiwiT2JqZWN0IiwiZGVmaW5lUHJvcGVydHkiLCJ2YWx1ZSIsImVudW1lcmFibGUiLCJjb25maWd1cmFibGUiLCJ3cml0YWJsZSIsImkiLCJfdG9QcmltaXRpdmUiLCJTeW1ib2wiLCJ0b1ByaW1pdGl2ZSIsImNhbGwiLCJUeXBlRXJyb3IiLCJTdHJpbmciLCJOdW1iZXIiLCJNYW5hZ2VkSW5kZXhTZXJ2aWNlIiwiTURTRW5hYmxlZENsaWVudFNlcnZpY2UiLCJjb25zdHJ1Y3RvciIsImFyZ3MiLCJjb250ZXh0IiwicmVxdWVzdCIsInJlc3BvbnNlIiwiaWQiLCJwYXJhbXMiLCJpbmRleCIsIklOREVYIiwiT1BFTkRJU1RST19JU01fQ09ORklHIiwiY2FsbFdpdGhSZXF1ZXN0IiwiZ2V0Q2xpZW50QmFzZWRPbkRhdGFTb3VyY2UiLCJyZXN1bHRzIiwiY3VzdG9tIiwic3RhdHVzQ29kZSIsImJvZHkiLCJvayIsImVyciIsImNvbnNvbGUiLCJlcnJvciIsIm1lc3NhZ2UiLCJmcm9tIiwic2l6ZSIsInNvcnREaXJlY3Rpb24iLCJzb3J0RmllbGQiLCJ0ZXJtcyIsImluZGljZXMiLCJkYXRhU3RyZWFtcyIsInNob3dEYXRhU3RyZWFtcyIsInF1ZXJ5IiwibWFuYWdlZEluZGV4U29ydHMiLCJwb2xpY3lJZCIsImV4cGxhaW5QYXJhbXMiLCJzb3J0T3JkZXIiLCJxdWVyeVN0cmluZyIsImdldFNlYXJjaFN0cmluZyIsImV4cGxhaW5BbGxSZXNwb25zZSIsImluZGV4VG9EYXRhU3RyZWFtTWFwcGluZyIsIlByb21pc2UiLCJhbGwiLCJnZXRJbmRleFRvRGF0YVN0cmVhbU1hcHBpbmciLCJtYW5hZ2VkSW5kaWNlcyIsImluZGV4TmFtZSIsIm1ldGFkYXRhIiwicGFyZW50RGF0YVN0cmVhbSIsInBvbGljeSIsInNlcU5vIiwicHJpbWFyeVRlcm0iLCJnZXRSZXNwb25zZSIsInBvbGljeV9pZCIsInJlYXNvbiIsImxvZyIsIl8iLCJnZXQiLCJwdXNoIiwiaW5kZXhVdWlkIiwiaW5kZXhfdXVpZCIsImRhdGFTdHJlYW0iLCJwb2xpY3lTZXFObyIsInBvbGljeVByaW1hcnlUZXJtIiwiZW5hYmxlZCIsIm1hbmFnZWRJbmRleE1ldGFEYXRhIiwidHJhbnNmb3JtTWFuYWdlZEluZGV4TWV0YURhdGEiLCJ0b3RhbE1hbmFnZWRJbmRpY2VzIiwidG90YWxfbWFuYWdlZF9pbmRpY2VzIiwidHlwZSIsInN0YXRlIiwiY2FsbEFzQ3VycmVudFVzZXIiLCJvc0RyaXZlciIsImFzU2NvcGVkIiwiam9pbiIsInJldHJ5UmVzcG9uc2UiLCJmYWlsdXJlcyIsInVwZGF0ZWRJbmRpY2VzIiwidXBkYXRlZF9pbmRpY2VzIiwiZmFpbGVkSW5kaWNlcyIsImZhaWxlZF9pbmRpY2VzIiwibWFwIiwiZmFpbGVkSW5kZXgiLCJpbmRleF9uYW1lIiwiaW5jbHVkZSIsImNoYW5nZVJlc3BvbnNlIiwiYWRkUmVzcG9uc2UiLCJleHBvcnRzIiwibW9kdWxlIl0sInNvdXJjZXMiOlsiTWFuYWdlZEluZGV4U2VydmljZS50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxyXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcclxuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcclxuICovXHJcblxyXG5pbXBvcnQgXyBmcm9tIFwibG9kYXNoXCI7XHJcbmltcG9ydCB7IFJlcXVlc3RQYXJhbXMgfSBmcm9tIFwiQGVsYXN0aWMvZWxhc3RpY3NlYXJjaFwiO1xyXG5pbXBvcnQge1xyXG4gIFJlcXVlc3RIYW5kbGVyQ29udGV4dCxcclxuICBPcGVuU2VhcmNoRGFzaGJvYXJkc1JlcXVlc3QsXHJcbiAgT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZUZhY3RvcnksXHJcbiAgSU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2UsXHJcbn0gZnJvbSBcIm9wZW5zZWFyY2gtZGFzaGJvYXJkcy9zZXJ2ZXJcIjtcclxuaW1wb3J0IHsgSU5ERVggfSBmcm9tIFwiLi4vdXRpbHMvY29uc3RhbnRzXCI7XHJcbmltcG9ydCB7IGdldFNlYXJjaFN0cmluZywgdHJhbnNmb3JtTWFuYWdlZEluZGV4TWV0YURhdGEgfSBmcm9tIFwiLi4vdXRpbHMvaGVscGVyc1wiO1xyXG5pbXBvcnQge1xyXG4gIENoYW5nZVBvbGljeVJlc3BvbnNlLFxyXG4gIEV4cGxhaW5BbGxSZXNwb25zZSxcclxuICBFeHBsYWluQVBJTWFuYWdlZEluZGV4TWV0YURhdGEsXHJcbiAgR2V0TWFuYWdlZEluZGljZXNSZXNwb25zZSxcclxuICBSZW1vdmVQb2xpY3lSZXNwb25zZSxcclxuICBSZW1vdmVSZXNwb25zZSxcclxuICBSZXRyeU1hbmFnZWRJbmRleFJlc3BvbnNlLFxyXG4gIFJldHJ5UGFyYW1zLFxyXG4gIFJldHJ5UmVzcG9uc2UsXHJcbiAgU2VhcmNoUmVzcG9uc2UsXHJcbn0gZnJvbSBcIi4uL21vZGVscy9pbnRlcmZhY2VzXCI7XHJcbmltcG9ydCB7IE1hbmFnZWRJbmRpY2VzU29ydCwgU2VydmVyUmVzcG9uc2UgfSBmcm9tIFwiLi4vbW9kZWxzL3R5cGVzXCI7XHJcbmltcG9ydCB7IE1hbmFnZWRJbmRleEl0ZW0gfSBmcm9tIFwiLi4vLi4vbW9kZWxzL2ludGVyZmFjZXNcIjtcclxuaW1wb3J0IHsgZ2V0SW5kZXhUb0RhdGFTdHJlYW1NYXBwaW5nIH0gZnJvbSBcIi4vRGF0YVN0cmVhbVNlcnZpY2VcIjtcclxuaW1wb3J0IHsgTURTRW5hYmxlZENsaWVudFNlcnZpY2UgfSBmcm9tIFwiLi9NRFNFbmFibGVkQ2xpZW50U2VydmljZVwiO1xyXG5cclxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgTWFuYWdlZEluZGV4U2VydmljZSBleHRlbmRzIE1EU0VuYWJsZWRDbGllbnRTZXJ2aWNlIHtcclxuICAvLyBUT0RPOiBOb3QgZmluaXNoZWQsIG5lZWQgVUkgcGFnZSB0aGF0IHVzZXMgdGhpcyBmaXJzdFxyXG4gIGdldE1hbmFnZWRJbmRleCA9IGFzeW5jIChcclxuICAgIGNvbnRleHQ6IFJlcXVlc3RIYW5kbGVyQ29udGV4dCxcclxuICAgIHJlcXVlc3Q6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVxdWVzdCxcclxuICAgIHJlc3BvbnNlOiBPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlRmFjdG9yeVxyXG4gICk6IFByb21pc2U8SU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2U8U2VydmVyUmVzcG9uc2U8YW55Pj4+ID0+IHtcclxuICAgIHRyeSB7XHJcbiAgICAgIGNvbnN0IHsgaWQgfSA9IHJlcXVlc3QucGFyYW1zIGFzIHsgaWQ6IHN0cmluZyB9O1xyXG4gICAgICBjb25zdCBwYXJhbXM6IFJlcXVlc3RQYXJhbXMuR2V0ID0geyBpZCwgaW5kZXg6IElOREVYLk9QRU5ESVNUUk9fSVNNX0NPTkZJRyB9O1xyXG4gICAgICBjb25zdCBjYWxsV2l0aFJlcXVlc3QgPSB0aGlzLmdldENsaWVudEJhc2VkT25EYXRhU291cmNlKGNvbnRleHQsIHJlcXVlc3QpO1xyXG4gICAgICBjb25zdCByZXN1bHRzOiBTZWFyY2hSZXNwb25zZTxhbnk+ID0gKGF3YWl0IGNhbGxXaXRoUmVxdWVzdChcInNlYXJjaFwiLCBwYXJhbXMpKSBhcyBTZWFyY2hSZXNwb25zZTxhbnk+O1xyXG4gICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcclxuICAgICAgICBzdGF0dXNDb2RlOiAyMDAsXHJcbiAgICAgICAgYm9keToge1xyXG4gICAgICAgICAgb2s6IHRydWUsXHJcbiAgICAgICAgICByZXNwb25zZTogcmVzdWx0cyxcclxuICAgICAgICB9LFxyXG4gICAgICB9KTtcclxuICAgIH0gY2F0Y2ggKGVycikge1xyXG4gICAgICBjb25zb2xlLmVycm9yKFwiSW5kZXggTWFuYWdlbWVudCAtIE1hbmFnZWRJbmRleFNlcnZpY2UgLSBnZXRNYW5hZ2VkSW5kZXg6XCIsIGVycik7XHJcbiAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xyXG4gICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcclxuICAgICAgICBib2R5OiB7XHJcbiAgICAgICAgICBvazogZmFsc2UsXHJcbiAgICAgICAgICBlcnJvcjogZXJyLm1lc3NhZ2UsXHJcbiAgICAgICAgfSxcclxuICAgICAgfSk7XHJcbiAgICB9XHJcbiAgfTtcclxuXHJcbiAgZ2V0TWFuYWdlZEluZGljZXMgPSBhc3luYyAoXHJcbiAgICBjb250ZXh0OiBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXHJcbiAgICByZXF1ZXN0OiBPcGVuU2VhcmNoRGFzaGJvYXJkc1JlcXVlc3QsXHJcbiAgICByZXNwb25zZTogT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZUZhY3RvcnlcclxuICApOiBQcm9taXNlPElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPFNlcnZlclJlc3BvbnNlPEdldE1hbmFnZWRJbmRpY2VzUmVzcG9uc2U+Pj4gPT4ge1xyXG4gICAgdHJ5IHtcclxuICAgICAgY29uc3QgeyBmcm9tLCBzaXplLCBzb3J0RGlyZWN0aW9uLCBzb3J0RmllbGQsIHRlcm1zLCBpbmRpY2VzLCBkYXRhU3RyZWFtcywgc2hvd0RhdGFTdHJlYW1zIH0gPSByZXF1ZXN0LnF1ZXJ5IGFzIHtcclxuICAgICAgICBmcm9tOiBzdHJpbmc7XHJcbiAgICAgICAgc2l6ZTogc3RyaW5nO1xyXG4gICAgICAgIHNlYXJjaDogc3RyaW5nO1xyXG4gICAgICAgIHNvcnREaXJlY3Rpb246IHN0cmluZztcclxuICAgICAgICBzb3J0RmllbGQ6IHN0cmluZztcclxuICAgICAgICB0ZXJtcz86IHN0cmluZ1tdO1xyXG4gICAgICAgIGluZGljZXM/OiBzdHJpbmdbXTtcclxuICAgICAgICBkYXRhU3RyZWFtcz86IHN0cmluZ1tdO1xyXG4gICAgICAgIHNob3dEYXRhU3RyZWFtczogYm9vbGVhbjtcclxuICAgICAgfTtcclxuXHJcbiAgICAgIGNvbnN0IG1hbmFnZWRJbmRleFNvcnRzOiBNYW5hZ2VkSW5kaWNlc1NvcnQgPSB7IGluZGV4OiBcIm1hbmFnZWRfaW5kZXguaW5kZXhcIiwgcG9saWN5SWQ6IFwibWFuYWdlZF9pbmRleC5wb2xpY3lfaWRcIiB9O1xyXG4gICAgICBjb25zdCBleHBsYWluUGFyYW1zID0ge1xyXG4gICAgICAgIHNvcnRGaWVsZDogc29ydEZpZWxkID8gbWFuYWdlZEluZGV4U29ydHNbc29ydEZpZWxkXSA6IG51bGwsXHJcbiAgICAgICAgc29ydE9yZGVyOiBzb3J0RGlyZWN0aW9uLFxyXG4gICAgICAgIHF1ZXJ5U3RyaW5nOiBnZXRTZWFyY2hTdHJpbmcodGVybXMsIGluZGljZXMsIGRhdGFTdHJlYW1zLCBzaG93RGF0YVN0cmVhbXMpLFxyXG4gICAgICAgIGZyb206IGZyb20sXHJcbiAgICAgICAgc2l6ZTogc2l6ZSxcclxuICAgICAgfTtcclxuXHJcbiAgICAgIGNvbnN0IGNhbGxXaXRoUmVxdWVzdCA9IHRoaXMuZ2V0Q2xpZW50QmFzZWRPbkRhdGFTb3VyY2UoY29udGV4dCwgcmVxdWVzdCk7XHJcbiAgICAgIGNvbnN0IFtleHBsYWluQWxsUmVzcG9uc2UsIGluZGV4VG9EYXRhU3RyZWFtTWFwcGluZ10gPSBhd2FpdCBQcm9taXNlLmFsbChbXHJcbiAgICAgICAgY2FsbFdpdGhSZXF1ZXN0KFwiaXNtLmV4cGxhaW5BbGxcIiwgZXhwbGFpblBhcmFtcykgYXMgUHJvbWlzZTxFeHBsYWluQWxsUmVzcG9uc2U+LFxyXG4gICAgICAgIGdldEluZGV4VG9EYXRhU3RyZWFtTWFwcGluZyhjYWxsV2l0aFJlcXVlc3QpLFxyXG4gICAgICBdKTtcclxuICAgICAgY29uc3QgbWFuYWdlZEluZGljZXM6IE1hbmFnZWRJbmRleEl0ZW1bXSA9IFtdO1xyXG4gICAgICBmb3IgKGNvbnN0IGluZGV4TmFtZSBpbiBleHBsYWluQWxsUmVzcG9uc2UpIHtcclxuICAgICAgICBpZiAoaW5kZXhOYW1lID09IFwidG90YWxfbWFuYWdlZF9pbmRpY2VzXCIpIGNvbnRpbnVlO1xyXG4gICAgICAgIGNvbnN0IG1ldGFkYXRhID0gZXhwbGFpbkFsbFJlc3BvbnNlW2luZGV4TmFtZV0gYXMgRXhwbGFpbkFQSU1hbmFnZWRJbmRleE1ldGFEYXRhO1xyXG5cclxuICAgICAgICAvLyBJZiBzaG93RGF0YVN0cmVhbXMgaXMgbm90IHRydWUsIHRoZW4gc2tpcCB0aGUgbWFuYWdlZCBpbmRleCBpZiBpdCBiZWxvbmdzIHRvIGEgZGF0YSBzdHJlYW0uXHJcbiAgICAgICAgY29uc3QgcGFyZW50RGF0YVN0cmVhbSA9IGluZGV4VG9EYXRhU3RyZWFtTWFwcGluZ1ttZXRhZGF0YS5pbmRleF0gfHwgbnVsbDtcclxuICAgICAgICBpZiAoIXNob3dEYXRhU3RyZWFtcyAmJiBwYXJlbnREYXRhU3RyZWFtICE9PSBudWxsKSBjb250aW51ZTtcclxuICAgICAgICBsZXQgcG9saWN5LCBzZXFObywgcHJpbWFyeVRlcm0sIGdldFJlc3BvbnNlO1xyXG4gICAgICAgIHRyeSB7XHJcbiAgICAgICAgICBnZXRSZXNwb25zZSA9IGF3YWl0IGNhbGxXaXRoUmVxdWVzdChcImlzbS5nZXRQb2xpY3lcIiwgeyBwb2xpY3lJZDogbWV0YWRhdGEucG9saWN5X2lkIH0pO1xyXG4gICAgICAgIH0gY2F0Y2ggKGVycikge1xyXG4gICAgICAgICAgaWYgKGVyci5zdGF0dXNDb2RlID09PSA0MDQgJiYgZXJyLmJvZHkuZXJyb3IucmVhc29uID09PSBcIlBvbGljeSBub3QgZm91bmRcIikge1xyXG4gICAgICAgICAgICBjb25zb2xlLmxvZyhcIm1hbmFnZWQgaW5kZXggd2l0aCBub3QgZXhpc3RpbmcgcG9saWN5XCIpO1xyXG4gICAgICAgICAgfSBlbHNlIHtcclxuICAgICAgICAgICAgdGhyb3cgZXJyO1xyXG4gICAgICAgICAgfVxyXG4gICAgICAgIH1cclxuICAgICAgICBwb2xpY3kgPSBfLmdldChnZXRSZXNwb25zZSwgXCJwb2xpY3lcIiwgbnVsbCk7XHJcbiAgICAgICAgc2VxTm8gPSBfLmdldChnZXRSZXNwb25zZSwgXCJfc2VxX25vXCIsIG51bGwpO1xyXG4gICAgICAgIHByaW1hcnlUZXJtID0gXy5nZXQoZ2V0UmVzcG9uc2UsIFwiX3ByaW1hcnlfdGVybVwiLCBudWxsKTtcclxuICAgICAgICBtYW5hZ2VkSW5kaWNlcy5wdXNoKHtcclxuICAgICAgICAgIGluZGV4OiBtZXRhZGF0YS5pbmRleCxcclxuICAgICAgICAgIGluZGV4VXVpZDogbWV0YWRhdGEuaW5kZXhfdXVpZCxcclxuICAgICAgICAgIGRhdGFTdHJlYW06IHBhcmVudERhdGFTdHJlYW0sXHJcbiAgICAgICAgICBwb2xpY3lJZDogbWV0YWRhdGEucG9saWN5X2lkLFxyXG4gICAgICAgICAgcG9saWN5U2VxTm86IHNlcU5vLFxyXG4gICAgICAgICAgcG9saWN5UHJpbWFyeVRlcm06IHByaW1hcnlUZXJtLFxyXG4gICAgICAgICAgcG9saWN5OiBwb2xpY3ksXHJcbiAgICAgICAgICBlbmFibGVkOiBtZXRhZGF0YS5lbmFibGVkLFxyXG4gICAgICAgICAgbWFuYWdlZEluZGV4TWV0YURhdGE6IHRyYW5zZm9ybU1hbmFnZWRJbmRleE1ldGFEYXRhKG1ldGFkYXRhKSxcclxuICAgICAgICB9KTtcclxuICAgICAgfVxyXG5cclxuICAgICAgbGV0IHRvdGFsTWFuYWdlZEluZGljZXMgPSBleHBsYWluQWxsUmVzcG9uc2UudG90YWxfbWFuYWdlZF9pbmRpY2VzO1xyXG4gICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcclxuICAgICAgICBzdGF0dXNDb2RlOiAyMDAsXHJcbiAgICAgICAgYm9keToge1xyXG4gICAgICAgICAgb2s6IHRydWUsXHJcbiAgICAgICAgICByZXNwb25zZTogeyBtYW5hZ2VkSW5kaWNlczogbWFuYWdlZEluZGljZXMsIHRvdGFsTWFuYWdlZEluZGljZXM6IHRvdGFsTWFuYWdlZEluZGljZXMgfSxcclxuICAgICAgICB9LFxyXG4gICAgICB9KTtcclxuICAgIH0gY2F0Y2ggKGVycikge1xyXG4gICAgICBpZiAoZXJyLnN0YXR1c0NvZGUgPT09IDQwNCAmJiBlcnIuYm9keS5lcnJvci50eXBlID09PSBcImluZGV4X25vdF9mb3VuZF9leGNlcHRpb25cIikge1xyXG4gICAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xyXG4gICAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxyXG4gICAgICAgICAgYm9keToge1xyXG4gICAgICAgICAgICBvazogdHJ1ZSxcclxuICAgICAgICAgICAgcmVzcG9uc2U6IHsgbWFuYWdlZEluZGljZXM6IFtdLCB0b3RhbE1hbmFnZWRJbmRpY2VzOiAwIH0sXHJcbiAgICAgICAgICB9LFxyXG4gICAgICAgIH0pO1xyXG4gICAgICB9XHJcbiAgICAgIGNvbnNvbGUuZXJyb3IoXCJJbmRleCBNYW5hZ2VtZW50IC0gTWFuYWdlZEluZGV4U2VydmljZSAtIGdldE1hbmFnZWRJbmRpY2VzXCIsIGVycik7XHJcbiAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xyXG4gICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcclxuICAgICAgICBib2R5OiB7XHJcbiAgICAgICAgICBvazogZmFsc2UsXHJcbiAgICAgICAgICBlcnJvcjogZXJyLm1lc3NhZ2UsXHJcbiAgICAgICAgfSxcclxuICAgICAgfSk7XHJcbiAgICB9XHJcbiAgfTtcclxuXHJcbiAgcmV0cnlNYW5hZ2VkSW5kZXhQb2xpY3kgPSBhc3luYyAoXHJcbiAgICBjb250ZXh0OiBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXHJcbiAgICByZXF1ZXN0OiBPcGVuU2VhcmNoRGFzaGJvYXJkc1JlcXVlc3QsXHJcbiAgICByZXNwb25zZTogT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZUZhY3RvcnlcclxuICApOiBQcm9taXNlPElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPFNlcnZlclJlc3BvbnNlPFJldHJ5TWFuYWdlZEluZGV4UmVzcG9uc2U+Pj4gPT4ge1xyXG4gICAgdHJ5IHtcclxuICAgICAgY29uc3QgeyBpbmRleCwgc3RhdGUgPSBudWxsIH0gPSByZXF1ZXN0LmJvZHkgYXMgeyBpbmRleDogc3RyaW5nW107IHN0YXRlPzogc3RyaW5nIH07XHJcbiAgICAgIGNvbnN0IHsgY2FsbEFzQ3VycmVudFVzZXI6IGNhbGxXaXRoUmVxdWVzdCB9ID0gdGhpcy5vc0RyaXZlci5hc1Njb3BlZChyZXF1ZXN0KTtcclxuICAgICAgY29uc3QgcGFyYW1zOiBSZXRyeVBhcmFtcyA9IHsgaW5kZXg6IGluZGV4LmpvaW4oXCIsXCIpIH07XHJcbiAgICAgIGlmIChzdGF0ZSkgcGFyYW1zLmJvZHkgPSB7IHN0YXRlIH07XHJcbiAgICAgIGNvbnN0IHJldHJ5UmVzcG9uc2U6IFJldHJ5UmVzcG9uc2UgPSBhd2FpdCBjYWxsV2l0aFJlcXVlc3QoXCJpc20ucmV0cnlcIiwgcGFyYW1zKTtcclxuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XHJcbiAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxyXG4gICAgICAgIGJvZHk6IHtcclxuICAgICAgICAgIG9rOiB0cnVlLFxyXG4gICAgICAgICAgcmVzcG9uc2U6IHtcclxuICAgICAgICAgICAgZmFpbHVyZXM6IHJldHJ5UmVzcG9uc2UuZmFpbHVyZXMsXHJcbiAgICAgICAgICAgIHVwZGF0ZWRJbmRpY2VzOiByZXRyeVJlc3BvbnNlLnVwZGF0ZWRfaW5kaWNlcyxcclxuICAgICAgICAgICAgLy8gVE9ETzogcmVtb3ZlIHRlcm5hcnkgYWZ0ZXIgZml4aW5nIHJldHJ5IEFQSSB0byByZXR1cm4gZW1wdHkgYXJyYXkgZXZlbiBpZiBubyBmYWlsdXJlc1xyXG4gICAgICAgICAgICBmYWlsZWRJbmRpY2VzOiByZXRyeVJlc3BvbnNlLmZhaWxlZF9pbmRpY2VzXHJcbiAgICAgICAgICAgICAgPyByZXRyeVJlc3BvbnNlLmZhaWxlZF9pbmRpY2VzLm1hcCgoZmFpbGVkSW5kZXgpID0+ICh7XHJcbiAgICAgICAgICAgICAgICAgIGluZGV4TmFtZTogZmFpbGVkSW5kZXguaW5kZXhfbmFtZSxcclxuICAgICAgICAgICAgICAgICAgaW5kZXhVdWlkOiBmYWlsZWRJbmRleC5pbmRleF91dWlkLFxyXG4gICAgICAgICAgICAgICAgICByZWFzb246IGZhaWxlZEluZGV4LnJlYXNvbixcclxuICAgICAgICAgICAgICAgIH0pKVxyXG4gICAgICAgICAgICAgIDogW10sXHJcbiAgICAgICAgICB9LFxyXG4gICAgICAgIH0sXHJcbiAgICAgIH0pO1xyXG4gICAgfSBjYXRjaCAoZXJyKSB7XHJcbiAgICAgIGNvbnNvbGUuZXJyb3IoXCJJbmRleCBNYW5hZ2VtZW50IC0gTWFuYWdlZEluZGV4U2VydmljZSAtIHJldHJ5TWFuYWdlZEluZGV4UG9saWN5OlwiLCBlcnIpO1xyXG4gICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcclxuICAgICAgICBzdGF0dXNDb2RlOiAyMDAsXHJcbiAgICAgICAgYm9keToge1xyXG4gICAgICAgICAgb2s6IGZhbHNlLFxyXG4gICAgICAgICAgZXJyb3I6IGVyci5tZXNzYWdlLFxyXG4gICAgICAgIH0sXHJcbiAgICAgIH0pO1xyXG4gICAgfVxyXG4gIH07XHJcblxyXG4gIGNoYW5nZVBvbGljeSA9IGFzeW5jIChcclxuICAgIGNvbnRleHQ6IFJlcXVlc3RIYW5kbGVyQ29udGV4dCxcclxuICAgIHJlcXVlc3Q6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVxdWVzdCxcclxuICAgIHJlc3BvbnNlOiBPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlRmFjdG9yeVxyXG4gICk6IFByb21pc2U8SU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2U8U2VydmVyUmVzcG9uc2U8Q2hhbmdlUG9saWN5UmVzcG9uc2U+Pj4gPT4ge1xyXG4gICAgdHJ5IHtcclxuICAgICAgY29uc3QgeyBpbmRpY2VzLCBwb2xpY3lJZCwgaW5jbHVkZSwgc3RhdGUgfSA9IHJlcXVlc3QuYm9keSBhcyB7XHJcbiAgICAgICAgaW5kaWNlczogc3RyaW5nW107XHJcbiAgICAgICAgcG9saWN5SWQ6IHN0cmluZztcclxuICAgICAgICBzdGF0ZTogc3RyaW5nIHwgbnVsbDtcclxuICAgICAgICBpbmNsdWRlOiB7IHN0YXRlOiBzdHJpbmcgfVtdO1xyXG4gICAgICB9O1xyXG4gICAgICBjb25zdCBjYWxsV2l0aFJlcXVlc3QgPSB0aGlzLmdldENsaWVudEJhc2VkT25EYXRhU291cmNlKGNvbnRleHQsIHJlcXVlc3QpO1xyXG4gICAgICBjb25zdCBwYXJhbXMgPSB7IGluZGV4OiBpbmRpY2VzLmpvaW4oXCIsXCIpLCBib2R5OiB7IHBvbGljeV9pZDogcG9saWN5SWQsIGluY2x1ZGUsIHN0YXRlIH0gfTtcclxuICAgICAgY29uc3QgY2hhbmdlUmVzcG9uc2U6IFJlbW92ZVJlc3BvbnNlID0gKGF3YWl0IGNhbGxXaXRoUmVxdWVzdChcImlzbS5jaGFuZ2VcIiwgcGFyYW1zKSkgYXMgUmVtb3ZlUmVzcG9uc2U7XHJcbiAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xyXG4gICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcclxuICAgICAgICBib2R5OiB7XHJcbiAgICAgICAgICBvazogdHJ1ZSxcclxuICAgICAgICAgIHJlc3BvbnNlOiB7XHJcbiAgICAgICAgICAgIGZhaWx1cmVzOiBjaGFuZ2VSZXNwb25zZS5mYWlsdXJlcyxcclxuICAgICAgICAgICAgdXBkYXRlZEluZGljZXM6IGNoYW5nZVJlc3BvbnNlLnVwZGF0ZWRfaW5kaWNlcyxcclxuICAgICAgICAgICAgZmFpbGVkSW5kaWNlczogY2hhbmdlUmVzcG9uc2UuZmFpbGVkX2luZGljZXMubWFwKChmYWlsZWRJbmRleCkgPT4gKHtcclxuICAgICAgICAgICAgICBpbmRleE5hbWU6IGZhaWxlZEluZGV4LmluZGV4X25hbWUsXHJcbiAgICAgICAgICAgICAgaW5kZXhVdWlkOiBmYWlsZWRJbmRleC5pbmRleF91dWlkLFxyXG4gICAgICAgICAgICAgIHJlYXNvbjogZmFpbGVkSW5kZXgucmVhc29uLFxyXG4gICAgICAgICAgICB9KSksXHJcbiAgICAgICAgICB9LFxyXG4gICAgICAgIH0sXHJcbiAgICAgIH0pO1xyXG4gICAgfSBjYXRjaCAoZXJyKSB7XHJcbiAgICAgIGNvbnNvbGUuZXJyb3IoXCJJbmRleCBNYW5hZ2VtZW50IC0gTWFuYWdlZEluZGV4U2VydmljZSAtIGNoYW5nZVBvbGljeTpcIiwgZXJyKTtcclxuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XHJcbiAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxyXG4gICAgICAgIGJvZHk6IHtcclxuICAgICAgICAgIG9rOiBmYWxzZSxcclxuICAgICAgICAgIGVycm9yOiBlcnIubWVzc2FnZSxcclxuICAgICAgICB9LFxyXG4gICAgICB9KTtcclxuICAgIH1cclxuICB9O1xyXG5cclxuICByZW1vdmVQb2xpY3kgPSBhc3luYyAoXHJcbiAgICBjb250ZXh0OiBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXHJcbiAgICByZXF1ZXN0OiBPcGVuU2VhcmNoRGFzaGJvYXJkc1JlcXVlc3QsXHJcbiAgICByZXNwb25zZTogT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZUZhY3RvcnlcclxuICApOiBQcm9taXNlPElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPFNlcnZlclJlc3BvbnNlPFJlbW92ZVBvbGljeVJlc3BvbnNlPj4+ID0+IHtcclxuICAgIHRyeSB7XHJcbiAgICAgIGNvbnN0IHsgaW5kaWNlcyB9ID0gcmVxdWVzdC5ib2R5IGFzIHsgaW5kaWNlczogc3RyaW5nW10gfTtcclxuICAgICAgY29uc3QgY2FsbFdpdGhSZXF1ZXN0ID0gdGhpcy5nZXRDbGllbnRCYXNlZE9uRGF0YVNvdXJjZShjb250ZXh0LCByZXF1ZXN0KTtcclxuICAgICAgY29uc3QgcGFyYW1zID0geyBpbmRleDogaW5kaWNlcy5qb2luKFwiLFwiKSB9O1xyXG4gICAgICBjb25zdCBhZGRSZXNwb25zZTogUmVtb3ZlUmVzcG9uc2UgPSAoYXdhaXQgY2FsbFdpdGhSZXF1ZXN0KFwiaXNtLnJlbW92ZVwiLCBwYXJhbXMpKSBhcyBSZW1vdmVSZXNwb25zZTtcclxuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XHJcbiAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxyXG4gICAgICAgIGJvZHk6IHtcclxuICAgICAgICAgIG9rOiB0cnVlLFxyXG4gICAgICAgICAgcmVzcG9uc2U6IHtcclxuICAgICAgICAgICAgZmFpbHVyZXM6IGFkZFJlc3BvbnNlLmZhaWx1cmVzLFxyXG4gICAgICAgICAgICB1cGRhdGVkSW5kaWNlczogYWRkUmVzcG9uc2UudXBkYXRlZF9pbmRpY2VzLFxyXG4gICAgICAgICAgICBmYWlsZWRJbmRpY2VzOiBhZGRSZXNwb25zZS5mYWlsZWRfaW5kaWNlcy5tYXAoKGZhaWxlZEluZGV4KSA9PiAoe1xyXG4gICAgICAgICAgICAgIGluZGV4TmFtZTogZmFpbGVkSW5kZXguaW5kZXhfbmFtZSxcclxuICAgICAgICAgICAgICBpbmRleFV1aWQ6IGZhaWxlZEluZGV4LmluZGV4X3V1aWQsXHJcbiAgICAgICAgICAgICAgcmVhc29uOiBmYWlsZWRJbmRleC5yZWFzb24sXHJcbiAgICAgICAgICAgIH0pKSxcclxuICAgICAgICAgIH0sXHJcbiAgICAgICAgfSxcclxuICAgICAgfSk7XHJcbiAgICB9IGNhdGNoIChlcnIpIHtcclxuICAgICAgY29uc29sZS5lcnJvcihcIkluZGV4IE1hbmFnZW1lbnQgLSBNYW5hZ2VkSW5kZXhTZXJ2aWNlIC0gcmVtb3ZlUG9saWN5OlwiLCBlcnIpO1xyXG4gICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcclxuICAgICAgICBzdGF0dXNDb2RlOiAyMDAsXHJcbiAgICAgICAgYm9keToge1xyXG4gICAgICAgICAgb2s6IGZhbHNlLFxyXG4gICAgICAgICAgZXJyb3I6IGVyci5tZXNzYWdlLFxyXG4gICAgICAgIH0sXHJcbiAgICAgIH0pO1xyXG4gICAgfVxyXG4gIH07XHJcbn1cclxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFLQSxJQUFBQSxPQUFBLEdBQUFDLHNCQUFBLENBQUFDLE9BQUE7QUFRQSxJQUFBQyxVQUFBLEdBQUFELE9BQUE7QUFDQSxJQUFBRSxRQUFBLEdBQUFGLE9BQUE7QUFlQSxJQUFBRyxrQkFBQSxHQUFBSCxPQUFBO0FBQ0EsSUFBQUksd0JBQUEsR0FBQUosT0FBQTtBQUFvRSxTQUFBRCx1QkFBQU0sQ0FBQSxXQUFBQSxDQUFBLElBQUFBLENBQUEsQ0FBQUMsVUFBQSxHQUFBRCxDQUFBLEtBQUFFLE9BQUEsRUFBQUYsQ0FBQTtBQUFBLFNBQUFHLGdCQUFBSCxDQUFBLEVBQUFJLENBQUEsRUFBQUMsQ0FBQSxZQUFBRCxDQUFBLEdBQUFFLGNBQUEsQ0FBQUYsQ0FBQSxNQUFBSixDQUFBLEdBQUFPLE1BQUEsQ0FBQUMsY0FBQSxDQUFBUixDQUFBLEVBQUFJLENBQUEsSUFBQUssS0FBQSxFQUFBSixDQUFBLEVBQUFLLFVBQUEsTUFBQUMsWUFBQSxNQUFBQyxRQUFBLFVBQUFaLENBQUEsQ0FBQUksQ0FBQSxJQUFBQyxDQUFBLEVBQUFMLENBQUE7QUFBQSxTQUFBTSxlQUFBRCxDQUFBLFFBQUFRLENBQUEsR0FBQUMsWUFBQSxDQUFBVCxDQUFBLHVDQUFBUSxDQUFBLEdBQUFBLENBQUEsR0FBQUEsQ0FBQTtBQUFBLFNBQUFDLGFBQUFULENBQUEsRUFBQUQsQ0FBQSwyQkFBQUMsQ0FBQSxLQUFBQSxDQUFBLFNBQUFBLENBQUEsTUFBQUwsQ0FBQSxHQUFBSyxDQUFBLENBQUFVLE1BQUEsQ0FBQUMsV0FBQSxrQkFBQWhCLENBQUEsUUFBQWEsQ0FBQSxHQUFBYixDQUFBLENBQUFpQixJQUFBLENBQUFaLENBQUEsRUFBQUQsQ0FBQSx1Q0FBQVMsQ0FBQSxTQUFBQSxDQUFBLFlBQUFLLFNBQUEseUVBQUFkLENBQUEsR0FBQWUsTUFBQSxHQUFBQyxNQUFBLEVBQUFmLENBQUEsS0E5QnBFO0FBQ0E7QUFDQTtBQUNBO0FBNkJlLE1BQU1nQixtQkFBbUIsU0FBU0MsZ0RBQXVCLENBQUM7RUFBQUMsWUFBQSxHQUFBQyxJQUFBO0lBQUEsU0FBQUEsSUFBQTtJQUN2RTtJQUFBckIsZUFBQSwwQkFDa0IsT0FDaEJzQixPQUE4QixFQUM5QkMsT0FBb0MsRUFDcENDLFFBQTZDLEtBQ21CO01BQ2hFLElBQUk7UUFDRixNQUFNO1VBQUVDO1FBQUcsQ0FBQyxHQUFHRixPQUFPLENBQUNHLE1BQXdCO1FBQy9DLE1BQU1BLE1BQXlCLEdBQUc7VUFBRUQsRUFBRTtVQUFFRSxLQUFLLEVBQUVDLGdCQUFLLENBQUNDO1FBQXNCLENBQUM7UUFDNUUsTUFBTUMsZUFBZSxHQUFHLElBQUksQ0FBQ0MsMEJBQTBCLENBQUNULE9BQU8sRUFBRUMsT0FBTyxDQUFDO1FBQ3pFLE1BQU1TLE9BQTRCLEdBQUksTUFBTUYsZUFBZSxDQUFDLFFBQVEsRUFBRUosTUFBTSxDQUF5QjtRQUNyRyxPQUFPRixRQUFRLENBQUNTLE1BQU0sQ0FBQztVQUNyQkMsVUFBVSxFQUFFLEdBQUc7VUFDZkMsSUFBSSxFQUFFO1lBQ0pDLEVBQUUsRUFBRSxJQUFJO1lBQ1JaLFFBQVEsRUFBRVE7VUFDWjtRQUNGLENBQUMsQ0FBQztNQUNKLENBQUMsQ0FBQyxPQUFPSyxHQUFHLEVBQUU7UUFDWkMsT0FBTyxDQUFDQyxLQUFLLENBQUMsMkRBQTJELEVBQUVGLEdBQUcsQ0FBQztRQUMvRSxPQUFPYixRQUFRLENBQUNTLE1BQU0sQ0FBQztVQUNyQkMsVUFBVSxFQUFFLEdBQUc7VUFDZkMsSUFBSSxFQUFFO1lBQ0pDLEVBQUUsRUFBRSxLQUFLO1lBQ1RHLEtBQUssRUFBRUYsR0FBRyxDQUFDRztVQUNiO1FBQ0YsQ0FBQyxDQUFDO01BQ0o7SUFDRixDQUFDO0lBQUF4QyxlQUFBLDRCQUVtQixPQUNsQnNCLE9BQThCLEVBQzlCQyxPQUFvQyxFQUNwQ0MsUUFBNkMsS0FDeUM7TUFDdEYsSUFBSTtRQUNGLE1BQU07VUFBRWlCLElBQUk7VUFBRUMsSUFBSTtVQUFFQyxhQUFhO1VBQUVDLFNBQVM7VUFBRUMsS0FBSztVQUFFQyxPQUFPO1VBQUVDLFdBQVc7VUFBRUM7UUFBZ0IsQ0FBQyxHQUFHekIsT0FBTyxDQUFDMEIsS0FVdEc7UUFFRCxNQUFNQyxpQkFBcUMsR0FBRztVQUFFdkIsS0FBSyxFQUFFLHFCQUFxQjtVQUFFd0IsUUFBUSxFQUFFO1FBQTBCLENBQUM7UUFDbkgsTUFBTUMsYUFBYSxHQUFHO1VBQ3BCUixTQUFTLEVBQUVBLFNBQVMsR0FBR00saUJBQWlCLENBQUNOLFNBQVMsQ0FBQyxHQUFHLElBQUk7VUFDMURTLFNBQVMsRUFBRVYsYUFBYTtVQUN4QlcsV0FBVyxFQUFFLElBQUFDLHdCQUFlLEVBQUNWLEtBQUssRUFBRUMsT0FBTyxFQUFFQyxXQUFXLEVBQUVDLGVBQWUsQ0FBQztVQUMxRVAsSUFBSSxFQUFFQSxJQUFJO1VBQ1ZDLElBQUksRUFBRUE7UUFDUixDQUFDO1FBRUQsTUFBTVosZUFBZSxHQUFHLElBQUksQ0FBQ0MsMEJBQTBCLENBQUNULE9BQU8sRUFBRUMsT0FBTyxDQUFDO1FBQ3pFLE1BQU0sQ0FBQ2lDLGtCQUFrQixFQUFFQyx3QkFBd0IsQ0FBQyxHQUFHLE1BQU1DLE9BQU8sQ0FBQ0MsR0FBRyxDQUFDLENBQ3ZFN0IsZUFBZSxDQUFDLGdCQUFnQixFQUFFc0IsYUFBYSxDQUFDLEVBQ2hELElBQUFRLDhDQUEyQixFQUFDOUIsZUFBZSxDQUFDLENBQzdDLENBQUM7UUFDRixNQUFNK0IsY0FBa0MsR0FBRyxFQUFFO1FBQzdDLEtBQUssTUFBTUMsU0FBUyxJQUFJTixrQkFBa0IsRUFBRTtVQUMxQyxJQUFJTSxTQUFTLElBQUksdUJBQXVCLEVBQUU7VUFDMUMsTUFBTUMsUUFBUSxHQUFHUCxrQkFBa0IsQ0FBQ00sU0FBUyxDQUFtQzs7VUFFaEY7VUFDQSxNQUFNRSxnQkFBZ0IsR0FBR1Asd0JBQXdCLENBQUNNLFFBQVEsQ0FBQ3BDLEtBQUssQ0FBQyxJQUFJLElBQUk7VUFDekUsSUFBSSxDQUFDcUIsZUFBZSxJQUFJZ0IsZ0JBQWdCLEtBQUssSUFBSSxFQUFFO1VBQ25ELElBQUlDLE1BQU0sRUFBRUMsS0FBSyxFQUFFQyxXQUFXLEVBQUVDLFdBQVc7VUFDM0MsSUFBSTtZQUNGQSxXQUFXLEdBQUcsTUFBTXRDLGVBQWUsQ0FBQyxlQUFlLEVBQUU7Y0FBRXFCLFFBQVEsRUFBRVksUUFBUSxDQUFDTTtZQUFVLENBQUMsQ0FBQztVQUN4RixDQUFDLENBQUMsT0FBT2hDLEdBQUcsRUFBRTtZQUNaLElBQUlBLEdBQUcsQ0FBQ0gsVUFBVSxLQUFLLEdBQUcsSUFBSUcsR0FBRyxDQUFDRixJQUFJLENBQUNJLEtBQUssQ0FBQytCLE1BQU0sS0FBSyxrQkFBa0IsRUFBRTtjQUMxRWhDLE9BQU8sQ0FBQ2lDLEdBQUcsQ0FBQyx3Q0FBd0MsQ0FBQztZQUN2RCxDQUFDLE1BQU07Y0FDTCxNQUFNbEMsR0FBRztZQUNYO1VBQ0Y7VUFDQTRCLE1BQU0sR0FBR08sZUFBQyxDQUFDQyxHQUFHLENBQUNMLFdBQVcsRUFBRSxRQUFRLEVBQUUsSUFBSSxDQUFDO1VBQzNDRixLQUFLLEdBQUdNLGVBQUMsQ0FBQ0MsR0FBRyxDQUFDTCxXQUFXLEVBQUUsU0FBUyxFQUFFLElBQUksQ0FBQztVQUMzQ0QsV0FBVyxHQUFHSyxlQUFDLENBQUNDLEdBQUcsQ0FBQ0wsV0FBVyxFQUFFLGVBQWUsRUFBRSxJQUFJLENBQUM7VUFDdkRQLGNBQWMsQ0FBQ2EsSUFBSSxDQUFDO1lBQ2xCL0MsS0FBSyxFQUFFb0MsUUFBUSxDQUFDcEMsS0FBSztZQUNyQmdELFNBQVMsRUFBRVosUUFBUSxDQUFDYSxVQUFVO1lBQzlCQyxVQUFVLEVBQUViLGdCQUFnQjtZQUM1QmIsUUFBUSxFQUFFWSxRQUFRLENBQUNNLFNBQVM7WUFDNUJTLFdBQVcsRUFBRVosS0FBSztZQUNsQmEsaUJBQWlCLEVBQUVaLFdBQVc7WUFDOUJGLE1BQU0sRUFBRUEsTUFBTTtZQUNkZSxPQUFPLEVBQUVqQixRQUFRLENBQUNpQixPQUFPO1lBQ3pCQyxvQkFBb0IsRUFBRSxJQUFBQyxzQ0FBNkIsRUFBQ25CLFFBQVE7VUFDOUQsQ0FBQyxDQUFDO1FBQ0o7UUFFQSxJQUFJb0IsbUJBQW1CLEdBQUczQixrQkFBa0IsQ0FBQzRCLHFCQUFxQjtRQUNsRSxPQUFPNUQsUUFBUSxDQUFDUyxNQUFNLENBQUM7VUFDckJDLFVBQVUsRUFBRSxHQUFHO1VBQ2ZDLElBQUksRUFBRTtZQUNKQyxFQUFFLEVBQUUsSUFBSTtZQUNSWixRQUFRLEVBQUU7Y0FBRXFDLGNBQWMsRUFBRUEsY0FBYztjQUFFc0IsbUJBQW1CLEVBQUVBO1lBQW9CO1VBQ3ZGO1FBQ0YsQ0FBQyxDQUFDO01BQ0osQ0FBQyxDQUFDLE9BQU85QyxHQUFHLEVBQUU7UUFDWixJQUFJQSxHQUFHLENBQUNILFVBQVUsS0FBSyxHQUFHLElBQUlHLEdBQUcsQ0FBQ0YsSUFBSSxDQUFDSSxLQUFLLENBQUM4QyxJQUFJLEtBQUssMkJBQTJCLEVBQUU7VUFDakYsT0FBTzdELFFBQVEsQ0FBQ1MsTUFBTSxDQUFDO1lBQ3JCQyxVQUFVLEVBQUUsR0FBRztZQUNmQyxJQUFJLEVBQUU7Y0FDSkMsRUFBRSxFQUFFLElBQUk7Y0FDUlosUUFBUSxFQUFFO2dCQUFFcUMsY0FBYyxFQUFFLEVBQUU7Z0JBQUVzQixtQkFBbUIsRUFBRTtjQUFFO1lBQ3pEO1VBQ0YsQ0FBQyxDQUFDO1FBQ0o7UUFDQTdDLE9BQU8sQ0FBQ0MsS0FBSyxDQUFDLDREQUE0RCxFQUFFRixHQUFHLENBQUM7UUFDaEYsT0FBT2IsUUFBUSxDQUFDUyxNQUFNLENBQUM7VUFDckJDLFVBQVUsRUFBRSxHQUFHO1VBQ2ZDLElBQUksRUFBRTtZQUNKQyxFQUFFLEVBQUUsS0FBSztZQUNURyxLQUFLLEVBQUVGLEdBQUcsQ0FBQ0c7VUFDYjtRQUNGLENBQUMsQ0FBQztNQUNKO0lBQ0YsQ0FBQztJQUFBeEMsZUFBQSxrQ0FFeUIsT0FDeEJzQixPQUE4QixFQUM5QkMsT0FBb0MsRUFDcENDLFFBQTZDLEtBQ3lDO01BQ3RGLElBQUk7UUFDRixNQUFNO1VBQUVHLEtBQUs7VUFBRTJELEtBQUssR0FBRztRQUFLLENBQUMsR0FBRy9ELE9BQU8sQ0FBQ1ksSUFBMkM7UUFDbkYsTUFBTTtVQUFFb0QsaUJBQWlCLEVBQUV6RDtRQUFnQixDQUFDLEdBQUcsSUFBSSxDQUFDMEQsUUFBUSxDQUFDQyxRQUFRLENBQUNsRSxPQUFPLENBQUM7UUFDOUUsTUFBTUcsTUFBbUIsR0FBRztVQUFFQyxLQUFLLEVBQUVBLEtBQUssQ0FBQytELElBQUksQ0FBQyxHQUFHO1FBQUUsQ0FBQztRQUN0RCxJQUFJSixLQUFLLEVBQUU1RCxNQUFNLENBQUNTLElBQUksR0FBRztVQUFFbUQ7UUFBTSxDQUFDO1FBQ2xDLE1BQU1LLGFBQTRCLEdBQUcsTUFBTTdELGVBQWUsQ0FBQyxXQUFXLEVBQUVKLE1BQU0sQ0FBQztRQUMvRSxPQUFPRixRQUFRLENBQUNTLE1BQU0sQ0FBQztVQUNyQkMsVUFBVSxFQUFFLEdBQUc7VUFDZkMsSUFBSSxFQUFFO1lBQ0pDLEVBQUUsRUFBRSxJQUFJO1lBQ1JaLFFBQVEsRUFBRTtjQUNSb0UsUUFBUSxFQUFFRCxhQUFhLENBQUNDLFFBQVE7Y0FDaENDLGNBQWMsRUFBRUYsYUFBYSxDQUFDRyxlQUFlO2NBQzdDO2NBQ0FDLGFBQWEsRUFBRUosYUFBYSxDQUFDSyxjQUFjLEdBQ3ZDTCxhQUFhLENBQUNLLGNBQWMsQ0FBQ0MsR0FBRyxDQUFFQyxXQUFXLEtBQU07Z0JBQ2pEcEMsU0FBUyxFQUFFb0MsV0FBVyxDQUFDQyxVQUFVO2dCQUNqQ3hCLFNBQVMsRUFBRXVCLFdBQVcsQ0FBQ3RCLFVBQVU7Z0JBQ2pDTixNQUFNLEVBQUU0QixXQUFXLENBQUM1QjtjQUN0QixDQUFDLENBQUMsQ0FBQyxHQUNIO1lBQ047VUFDRjtRQUNGLENBQUMsQ0FBQztNQUNKLENBQUMsQ0FBQyxPQUFPakMsR0FBRyxFQUFFO1FBQ1pDLE9BQU8sQ0FBQ0MsS0FBSyxDQUFDLG1FQUFtRSxFQUFFRixHQUFHLENBQUM7UUFDdkYsT0FBT2IsUUFBUSxDQUFDUyxNQUFNLENBQUM7VUFDckJDLFVBQVUsRUFBRSxHQUFHO1VBQ2ZDLElBQUksRUFBRTtZQUNKQyxFQUFFLEVBQUUsS0FBSztZQUNURyxLQUFLLEVBQUVGLEdBQUcsQ0FBQ0c7VUFDYjtRQUNGLENBQUMsQ0FBQztNQUNKO0lBQ0YsQ0FBQztJQUFBeEMsZUFBQSx1QkFFYyxPQUNic0IsT0FBOEIsRUFDOUJDLE9BQW9DLEVBQ3BDQyxRQUE2QyxLQUNvQztNQUNqRixJQUFJO1FBQ0YsTUFBTTtVQUFFc0IsT0FBTztVQUFFSyxRQUFRO1VBQUVpRCxPQUFPO1VBQUVkO1FBQU0sQ0FBQyxHQUFHL0QsT0FBTyxDQUFDWSxJQUtyRDtRQUNELE1BQU1MLGVBQWUsR0FBRyxJQUFJLENBQUNDLDBCQUEwQixDQUFDVCxPQUFPLEVBQUVDLE9BQU8sQ0FBQztRQUN6RSxNQUFNRyxNQUFNLEdBQUc7VUFBRUMsS0FBSyxFQUFFbUIsT0FBTyxDQUFDNEMsSUFBSSxDQUFDLEdBQUcsQ0FBQztVQUFFdkQsSUFBSSxFQUFFO1lBQUVrQyxTQUFTLEVBQUVsQixRQUFRO1lBQUVpRCxPQUFPO1lBQUVkO1VBQU07UUFBRSxDQUFDO1FBQzFGLE1BQU1lLGNBQThCLEdBQUksTUFBTXZFLGVBQWUsQ0FBQyxZQUFZLEVBQUVKLE1BQU0sQ0FBb0I7UUFDdEcsT0FBT0YsUUFBUSxDQUFDUyxNQUFNLENBQUM7VUFDckJDLFVBQVUsRUFBRSxHQUFHO1VBQ2ZDLElBQUksRUFBRTtZQUNKQyxFQUFFLEVBQUUsSUFBSTtZQUNSWixRQUFRLEVBQUU7Y0FDUm9FLFFBQVEsRUFBRVMsY0FBYyxDQUFDVCxRQUFRO2NBQ2pDQyxjQUFjLEVBQUVRLGNBQWMsQ0FBQ1AsZUFBZTtjQUM5Q0MsYUFBYSxFQUFFTSxjQUFjLENBQUNMLGNBQWMsQ0FBQ0MsR0FBRyxDQUFFQyxXQUFXLEtBQU07Z0JBQ2pFcEMsU0FBUyxFQUFFb0MsV0FBVyxDQUFDQyxVQUFVO2dCQUNqQ3hCLFNBQVMsRUFBRXVCLFdBQVcsQ0FBQ3RCLFVBQVU7Z0JBQ2pDTixNQUFNLEVBQUU0QixXQUFXLENBQUM1QjtjQUN0QixDQUFDLENBQUM7WUFDSjtVQUNGO1FBQ0YsQ0FBQyxDQUFDO01BQ0osQ0FBQyxDQUFDLE9BQU9qQyxHQUFHLEVBQUU7UUFDWkMsT0FBTyxDQUFDQyxLQUFLLENBQUMsd0RBQXdELEVBQUVGLEdBQUcsQ0FBQztRQUM1RSxPQUFPYixRQUFRLENBQUNTLE1BQU0sQ0FBQztVQUNyQkMsVUFBVSxFQUFFLEdBQUc7VUFDZkMsSUFBSSxFQUFFO1lBQ0pDLEVBQUUsRUFBRSxLQUFLO1lBQ1RHLEtBQUssRUFBRUYsR0FBRyxDQUFDRztVQUNiO1FBQ0YsQ0FBQyxDQUFDO01BQ0o7SUFDRixDQUFDO0lBQUF4QyxlQUFBLHVCQUVjLE9BQ2JzQixPQUE4QixFQUM5QkMsT0FBb0MsRUFDcENDLFFBQTZDLEtBQ29DO01BQ2pGLElBQUk7UUFDRixNQUFNO1VBQUVzQjtRQUFRLENBQUMsR0FBR3ZCLE9BQU8sQ0FBQ1ksSUFBNkI7UUFDekQsTUFBTUwsZUFBZSxHQUFHLElBQUksQ0FBQ0MsMEJBQTBCLENBQUNULE9BQU8sRUFBRUMsT0FBTyxDQUFDO1FBQ3pFLE1BQU1HLE1BQU0sR0FBRztVQUFFQyxLQUFLLEVBQUVtQixPQUFPLENBQUM0QyxJQUFJLENBQUMsR0FBRztRQUFFLENBQUM7UUFDM0MsTUFBTVksV0FBMkIsR0FBSSxNQUFNeEUsZUFBZSxDQUFDLFlBQVksRUFBRUosTUFBTSxDQUFvQjtRQUNuRyxPQUFPRixRQUFRLENBQUNTLE1BQU0sQ0FBQztVQUNyQkMsVUFBVSxFQUFFLEdBQUc7VUFDZkMsSUFBSSxFQUFFO1lBQ0pDLEVBQUUsRUFBRSxJQUFJO1lBQ1JaLFFBQVEsRUFBRTtjQUNSb0UsUUFBUSxFQUFFVSxXQUFXLENBQUNWLFFBQVE7Y0FDOUJDLGNBQWMsRUFBRVMsV0FBVyxDQUFDUixlQUFlO2NBQzNDQyxhQUFhLEVBQUVPLFdBQVcsQ0FBQ04sY0FBYyxDQUFDQyxHQUFHLENBQUVDLFdBQVcsS0FBTTtnQkFDOURwQyxTQUFTLEVBQUVvQyxXQUFXLENBQUNDLFVBQVU7Z0JBQ2pDeEIsU0FBUyxFQUFFdUIsV0FBVyxDQUFDdEIsVUFBVTtnQkFDakNOLE1BQU0sRUFBRTRCLFdBQVcsQ0FBQzVCO2NBQ3RCLENBQUMsQ0FBQztZQUNKO1VBQ0Y7UUFDRixDQUFDLENBQUM7TUFDSixDQUFDLENBQUMsT0FBT2pDLEdBQUcsRUFBRTtRQUNaQyxPQUFPLENBQUNDLEtBQUssQ0FBQyx3REFBd0QsRUFBRUYsR0FBRyxDQUFDO1FBQzVFLE9BQU9iLFFBQVEsQ0FBQ1MsTUFBTSxDQUFDO1VBQ3JCQyxVQUFVLEVBQUUsR0FBRztVQUNmQyxJQUFJLEVBQUU7WUFDSkMsRUFBRSxFQUFFLEtBQUs7WUFDVEcsS0FBSyxFQUFFRixHQUFHLENBQUNHO1VBQ2I7UUFDRixDQUFDLENBQUM7TUFDSjtJQUNGLENBQUM7RUFBQTtBQUNIO0FBQUMrRCxPQUFBLENBQUF4RyxPQUFBLEdBQUFtQixtQkFBQTtBQUFBc0YsTUFBQSxDQUFBRCxPQUFBLEdBQUFBLE9BQUEsQ0FBQXhHLE9BQUEifQ==