"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MDSEnabledClientService = void 0;
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class MDSEnabledClientService {
  constructor(osDriver, dataSourceEnabled = false) {
    _defineProperty(this, "osDriver", void 0);
    _defineProperty(this, "dataSourceEnabled", void 0);
    this.osDriver = osDriver;
    this.dataSourceEnabled = dataSourceEnabled;
  }
  getClientBasedOnDataSource(context, request) {
    const {
      dataSourceId = ""
    } = request.query || {};
    if (this.dataSourceEnabled && dataSourceId && dataSourceId.trim().length != 0) {
      // non-zero data source id
      return context.dataSource.opensearch.legacy.getClient(dataSourceId).callAPI;
    } else {
      // fall back to default local cluster
      return this.osDriver.asScoped(request).callAsCurrentUser;
    }
  }
}
exports.MDSEnabledClientService = MDSEnabledClientService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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