"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.getDataStreams = getDataStreams;
exports.getIndexToDataStreamMapping = getIndexToDataStreamMapping;
var _constants = require("../utils/constants");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class DataStreamService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getDataStreams", async (context, request, response) => {
      try {
        const {
          search
        } = request.query;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const [dataStreams, apiAccessible, errMsg] = await getDataStreams(callWithRequest, search);
        if (!apiAccessible) return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: errMsg
          }
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              dataStreams: dataStreams,
              totalDataStreams: dataStreams.length
            }
          }
        });
      } catch (err) {
        console.error("Index Management - DataStreamService - getDataStreams:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
  }
}
exports.default = DataStreamService;
async function getDataStreams(callWithRequest, search) {
  const searchPattern = search ? `*${search}*` : "*";
  let accessible = true;
  let errMsg = "";
  const dataStreamsResponse = await callWithRequest("transport.request", {
    path: `/_data_stream/${searchPattern}`,
    method: "GET"
  }).catch(e => {
    if (e.statusCode === 403 && e.message.startsWith(_constants.SECURITY_EXCEPTION_PREFIX)) {
      accessible = false;
      errMsg = e.message;
      return {
        data_streams: []
      };
    }
    throw e;
  });
  return [dataStreamsResponse["data_streams"], accessible, errMsg];
}
async function getIndexToDataStreamMapping(callWithRequest) {
  const [dataStreams] = await getDataStreams(callWithRequest);
  const mapping = {};
  dataStreams.forEach(dataStream => {
    dataStream.indices.forEach(index => {
      mapping[index.index_name] = dataStream.name;
    });
  });
  return mapping;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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