"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
const VALID_METHODS = ["HEAD", "GET", "POST", "PUT", "DELETE"];
class CommonService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "apiCaller", async (context, request, response) => {
      const useQuery = !request.body;
      const usedParam = useQuery ? request.query : request.body;
      const {
        endpoint,
        data,
        hideLog
      } = usedParam || {};
      try {
        const finalData = data;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);

        /**
         * The endpoint must not be an empty string, reference from proxy caller
         */
        if (!endpoint) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: `Expected non-empty string on endpoint`
            }
          });
        }

        /**
         * Update path parameter to follow RFC/generic HTTP convention
         */
        if (endpoint === "transport.request" && typeof (finalData === null || finalData === void 0 ? void 0 : finalData.path) === "string" && !/^\//.test((finalData === null || finalData === void 0 ? void 0 : finalData.path) || "")) {
          finalData.path = `/${finalData.path || ""}`;
        }

        /**
         * Check valid method here
         */
        if (endpoint === "transport.request" && data !== null && data !== void 0 && data.method) {
          var _data$method$toUpperC, _data$method;
          if (VALID_METHODS.indexOf((_data$method$toUpperC = (_data$method = data.method).toUpperCase) === null || _data$method$toUpperC === void 0 ? void 0 : _data$method$toUpperC.call(_data$method)) === -1) {
            return response.custom({
              statusCode: 200,
              body: {
                ok: false,
                error: `Method must be one of, case insensitive ['HEAD', 'GET', 'POST', 'PUT', 'DELETE']. Received '${data.method}'.`
              }
            });
          }
        }
        const payload = useQuery ? JSON.parse(finalData || "{}") : finalData;
        const commonCallerResponse = await callWithRequest(endpoint, payload || {});
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: commonCallerResponse
          }
        });
      } catch (err) {
        if (!hideLog) {
          console.error("Index Management - CommonService - apiCaller", err);
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err === null || err === void 0 ? void 0 : err.message,
            body: (err === null || err === void 0 ? void 0 : err.body) || ""
          }
        });
      }
    });
  }
}
exports.default = CommonService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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