"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.getAliases = getAliases;
var _constants = require("../utils/constants");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class AliasServices extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getAliases", async (context, request, response) => {
      try {
        const {
          search
        } = request.query;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const [aliases, apiAccessible, errMsg] = await getAliases(callWithRequest, search);
        if (!apiAccessible) return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: errMsg
          }
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              aliases: aliases,
              totalAliases: aliases.length
            }
          }
        });
      } catch (err) {
        console.error("Index Management - AliasesService - getAliases:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
  }
}
exports.default = AliasServices;
async function getAliases(callWithRequest, search) {
  const searchPattern = search ? `*${search}*` : "*";
  let accessible = true;
  let errMsg = "";
  const aliasesResponse = await callWithRequest("cat.aliases", {
    format: "json",
    name: searchPattern
  }).catch(e => {
    if (e.statusCode === 403 && e.message.startsWith(_constants.SECURITY_EXCEPTION_PREFIX)) {
      accessible = false;
      errMsg = e.message;
      return {
        alias: []
      };
    }
    throw e;
  });
  return [aliasesResponse, accessible, errMsg];
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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