"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _constants = require("../../utils/constants");
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    snapshotManagementService
  } = services;
  router.get({
    path: _constants.NODE_API._SNAPSHOTS,
    validate: {
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.getAllSnapshotsWithPolicy);
  router.get({
    path: `${_constants.NODE_API._SNAPSHOTS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        repository: _configSchema.schema.string(),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.getSnapshot);
  router.delete({
    path: `${_constants.NODE_API._SNAPSHOTS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        repository: _configSchema.schema.string(),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.deleteSnapshot);
  router.put({
    path: `${_constants.NODE_API._SNAPSHOTS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        repository: _configSchema.schema.string(),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      }),
      body: _configSchema.schema.any()
    }
  }, snapshotManagementService.createSnapshot);
  router.post({
    path: `${_constants.NODE_API._SNAPSHOTS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        repository: _configSchema.schema.string(),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      }),
      body: _configSchema.schema.any()
    }
  }, snapshotManagementService.restoreSnapshot);
  router.post({
    path: `${_constants.NODE_API.SMPolicies}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.createPolicy);
  router.put({
    path: `${_constants.NODE_API.SMPolicies}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        seqNo: _configSchema.schema.maybe(_configSchema.schema.number()),
        primaryTerm: _configSchema.schema.maybe(_configSchema.schema.number()),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      }),
      body: _configSchema.schema.any()
    }
  }, snapshotManagementService.updatePolicy);
  router.get({
    path: _constants.NODE_API.SMPolicies,
    validate: {
      // for public service to pass object to server service
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        sortField: _configSchema.schema.string(),
        sortOrder: _configSchema.schema.string(),
        queryString: _configSchema.schema.string(),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.getPolicies);
  router.get({
    path: `${_constants.NODE_API.SMPolicies}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.getPolicy);
  router.delete({
    path: `${_constants.NODE_API.SMPolicies}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.deletePolicy);
  router.post({
    path: `${_constants.NODE_API.SMPolicies}/{id}/_start`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.startPolicy);
  router.post({
    path: `${_constants.NODE_API.SMPolicies}/{id}/_stop`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.stopPolicy);
  router.get({
    path: _constants.NODE_API._REPOSITORIES,
    validate: {
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.catRepositoriesWithSnapshotCount);
  router.get({
    path: `${_constants.NODE_API._INDICES}/{indices}`,
    validate: {
      params: _configSchema.schema.object({
        indices: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.catSnapshotIndices);
  router.get({
    path: _constants.NODE_API._RECOVERY,
    validate: {
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.getIndexRecovery);
  router.delete({
    path: `${_constants.NODE_API._REPOSITORIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.deleteRepository);
  router.get({
    path: `${_constants.NODE_API._REPOSITORIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.getRepository);
  router.put({
    path: `${_constants.NODE_API._REPOSITORIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.createRepository);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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