"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _constants = require("../../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    rollupService,
    transformService
  } = services;
  router.get({
    path: _constants.NODE_API.ROLLUPS,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.string(),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string(),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, rollupService.getRollups);
  router.put({
    path: `${_constants.NODE_API.ROLLUPS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        seqNo: _configSchema.schema.maybe(_configSchema.schema.number()),
        primaryTerm: _configSchema.schema.maybe(_configSchema.schema.number()),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      }),
      body: _configSchema.schema.any()
    }
  }, rollupService.putRollup);
  router.get({
    path: `${_constants.NODE_API.ROLLUPS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, rollupService.getRollup);
  router.delete({
    path: `${_constants.NODE_API.ROLLUPS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, rollupService.deleteRollup);
  router.post({
    path: `${_constants.NODE_API.ROLLUPS}/{id}/_start`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, rollupService.startRollup);
  router.post({
    path: `${_constants.NODE_API.ROLLUPS}/{id}/_stop`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, rollupService.stopRollup);
  router.post({
    path: _constants.NODE_API._MAPPINGS,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, rollupService.getMappings);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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