"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _constants = require("../../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    policyService
  } = services;
  router.get({
    path: _constants.NODE_API.POLICIES,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.string(),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string(),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, policyService.getPolicies);
  router.put({
    path: `${_constants.NODE_API.POLICIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        seqNo: _configSchema.schema.maybe(_configSchema.schema.number()),
        primaryTerm: _configSchema.schema.maybe(_configSchema.schema.number()),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      }),
      body: _configSchema.schema.any()
    }
  }, policyService.putPolicy);
  router.get({
    path: `${_constants.NODE_API.POLICIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, policyService.getPolicy);
  router.delete({
    path: `${_constants.NODE_API.POLICIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, policyService.deletePolicy);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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