"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _constants = require("../../utils/constants");
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    notificationService
  } = services;
  router.get({
    path: _constants.NODE_API.CHANNELS,
    validate: {
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, notificationService.getChannels);
  router.get({
    path: `${_constants.NODE_API.CHANNELS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, notificationService.getChannelById);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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