"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _constants = require("../../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    managedIndexService
  } = services;
  router.get({
    path: _constants.NODE_API.MANAGED_INDICES,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.string(),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string(),
        terms: _configSchema.schema.maybe(_configSchema.schema.any()),
        indices: _configSchema.schema.maybe(_configSchema.schema.any()),
        dataStreams: _configSchema.schema.maybe(_configSchema.schema.any()),
        showDataStreams: _configSchema.schema.boolean(),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, managedIndexService.getManagedIndices);
  router.get({
    path: `${_constants.NODE_API.MANAGED_INDICES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, managedIndexService.getManagedIndex);
  router.post({
    path: _constants.NODE_API.RETRY,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, managedIndexService.retryManagedIndexPolicy);
  router.post({
    path: _constants.NODE_API.CHANGE_POLICY,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, managedIndexService.changePolicy);
  router.post({
    path: _constants.NODE_API.REMOVE_POLICY,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, managedIndexService.removePolicy);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9jb25zdGFudHMiLCJfZGVmYXVsdCIsInNlcnZpY2VzIiwicm91dGVyIiwiZGF0YVNvdXJjZUVuYWJsZWQiLCJtYW5hZ2VkSW5kZXhTZXJ2aWNlIiwiZ2V0IiwicGF0aCIsIk5PREVfQVBJIiwiTUFOQUdFRF9JTkRJQ0VTIiwidmFsaWRhdGUiLCJxdWVyeSIsInNjaGVtYSIsIm9iamVjdCIsImZyb20iLCJudW1iZXIiLCJzaXplIiwic2VhcmNoIiwic3RyaW5nIiwic29ydEZpZWxkIiwic29ydERpcmVjdGlvbiIsInRlcm1zIiwibWF5YmUiLCJhbnkiLCJpbmRpY2VzIiwiZGF0YVN0cmVhbXMiLCJzaG93RGF0YVN0cmVhbXMiLCJib29sZWFuIiwiZGF0YVNvdXJjZUlkIiwiZ2V0TWFuYWdlZEluZGljZXMiLCJwYXJhbXMiLCJpZCIsImdldE1hbmFnZWRJbmRleCIsInBvc3QiLCJSRVRSWSIsImJvZHkiLCJyZXRyeU1hbmFnZWRJbmRleFBvbGljeSIsIkNIQU5HRV9QT0xJQ1kiLCJjaGFuZ2VQb2xpY3kiLCJSRU1PVkVfUE9MSUNZIiwicmVtb3ZlUG9saWN5IiwibW9kdWxlIiwiZXhwb3J0cyIsImRlZmF1bHQiXSwic291cmNlcyI6WyJtYW5hZ2VkSW5kaWNlcy50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxyXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcclxuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcclxuICovXHJcblxyXG5pbXBvcnQgeyBJUm91dGVyIH0gZnJvbSBcIm9wZW5zZWFyY2gtZGFzaGJvYXJkcy9zZXJ2ZXJcIjtcclxuaW1wb3J0IHsgc2NoZW1hIH0gZnJvbSBcIkBvc2QvY29uZmlnLXNjaGVtYVwiO1xyXG5pbXBvcnQgeyBOb2RlU2VydmljZXMgfSBmcm9tIFwiLi4vbW9kZWxzL2ludGVyZmFjZXNcIjtcclxuaW1wb3J0IHsgTk9ERV9BUEkgfSBmcm9tIFwiLi4vLi4vdXRpbHMvY29uc3RhbnRzXCI7XHJcblxyXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAoc2VydmljZXM6IE5vZGVTZXJ2aWNlcywgcm91dGVyOiBJUm91dGVyLCBkYXRhU291cmNlRW5hYmxlZDogYm9vbGVhbikge1xyXG4gIGNvbnN0IHsgbWFuYWdlZEluZGV4U2VydmljZSB9ID0gc2VydmljZXM7XHJcblxyXG4gIHJvdXRlci5nZXQoXHJcbiAgICB7XHJcbiAgICAgIHBhdGg6IE5PREVfQVBJLk1BTkFHRURfSU5ESUNFUyxcclxuICAgICAgdmFsaWRhdGU6IHtcclxuICAgICAgICBxdWVyeTogc2NoZW1hLm9iamVjdCh7XHJcbiAgICAgICAgICBmcm9tOiBzY2hlbWEubnVtYmVyKCksXHJcbiAgICAgICAgICBzaXplOiBzY2hlbWEubnVtYmVyKCksXHJcbiAgICAgICAgICBzZWFyY2g6IHNjaGVtYS5zdHJpbmcoKSxcclxuICAgICAgICAgIHNvcnRGaWVsZDogc2NoZW1hLnN0cmluZygpLFxyXG4gICAgICAgICAgc29ydERpcmVjdGlvbjogc2NoZW1hLnN0cmluZygpLFxyXG4gICAgICAgICAgdGVybXM6IHNjaGVtYS5tYXliZShzY2hlbWEuYW55KCkpLFxyXG4gICAgICAgICAgaW5kaWNlczogc2NoZW1hLm1heWJlKHNjaGVtYS5hbnkoKSksXHJcbiAgICAgICAgICBkYXRhU3RyZWFtczogc2NoZW1hLm1heWJlKHNjaGVtYS5hbnkoKSksXHJcbiAgICAgICAgICBzaG93RGF0YVN0cmVhbXM6IHNjaGVtYS5ib29sZWFuKCksXHJcbiAgICAgICAgICAuLi4oZGF0YVNvdXJjZUVuYWJsZWQgPyB7IGRhdGFTb3VyY2VJZDogc2NoZW1hLnN0cmluZygpIH0gOiB7fSksXHJcbiAgICAgICAgfSksXHJcbiAgICAgIH0sXHJcbiAgICB9LFxyXG4gICAgbWFuYWdlZEluZGV4U2VydmljZS5nZXRNYW5hZ2VkSW5kaWNlc1xyXG4gICk7XHJcblxyXG4gIHJvdXRlci5nZXQoXHJcbiAgICB7XHJcbiAgICAgIHBhdGg6IGAke05PREVfQVBJLk1BTkFHRURfSU5ESUNFU30ve2lkfWAsXHJcbiAgICAgIHZhbGlkYXRlOiB7XHJcbiAgICAgICAgcGFyYW1zOiBzY2hlbWEub2JqZWN0KHtcclxuICAgICAgICAgIGlkOiBzY2hlbWEuc3RyaW5nKCksXHJcbiAgICAgICAgfSksXHJcbiAgICAgICAgcXVlcnk6IHNjaGVtYS5vYmplY3Qoe1xyXG4gICAgICAgICAgLi4uKGRhdGFTb3VyY2VFbmFibGVkID8geyBkYXRhU291cmNlSWQ6IHNjaGVtYS5zdHJpbmcoKSB9IDoge30pLFxyXG4gICAgICAgIH0pLFxyXG4gICAgICB9LFxyXG4gICAgfSxcclxuICAgIG1hbmFnZWRJbmRleFNlcnZpY2UuZ2V0TWFuYWdlZEluZGV4XHJcbiAgKTtcclxuXHJcbiAgcm91dGVyLnBvc3QoXHJcbiAgICB7XHJcbiAgICAgIHBhdGg6IE5PREVfQVBJLlJFVFJZLFxyXG4gICAgICB2YWxpZGF0ZToge1xyXG4gICAgICAgIGJvZHk6IHNjaGVtYS5hbnkoKSxcclxuICAgICAgICBxdWVyeTogc2NoZW1hLm9iamVjdCh7XHJcbiAgICAgICAgICAuLi4oZGF0YVNvdXJjZUVuYWJsZWQgPyB7IGRhdGFTb3VyY2VJZDogc2NoZW1hLnN0cmluZygpIH0gOiB7fSksXHJcbiAgICAgICAgfSksXHJcbiAgICAgIH0sXHJcbiAgICB9LFxyXG4gICAgbWFuYWdlZEluZGV4U2VydmljZS5yZXRyeU1hbmFnZWRJbmRleFBvbGljeVxyXG4gICk7XHJcblxyXG4gIHJvdXRlci5wb3N0KFxyXG4gICAge1xyXG4gICAgICBwYXRoOiBOT0RFX0FQSS5DSEFOR0VfUE9MSUNZLFxyXG4gICAgICB2YWxpZGF0ZToge1xyXG4gICAgICAgIGJvZHk6IHNjaGVtYS5hbnkoKSxcclxuICAgICAgICBxdWVyeTogc2NoZW1hLm9iamVjdCh7XHJcbiAgICAgICAgICAuLi4oZGF0YVNvdXJjZUVuYWJsZWQgPyB7IGRhdGFTb3VyY2VJZDogc2NoZW1hLnN0cmluZygpIH0gOiB7fSksXHJcbiAgICAgICAgfSksXHJcbiAgICAgIH0sXHJcbiAgICB9LFxyXG4gICAgbWFuYWdlZEluZGV4U2VydmljZS5jaGFuZ2VQb2xpY3lcclxuICApO1xyXG5cclxuICByb3V0ZXIucG9zdChcclxuICAgIHtcclxuICAgICAgcGF0aDogTk9ERV9BUEkuUkVNT1ZFX1BPTElDWSxcclxuICAgICAgdmFsaWRhdGU6IHtcclxuICAgICAgICBib2R5OiBzY2hlbWEuYW55KCksXHJcbiAgICAgICAgcXVlcnk6IHNjaGVtYS5vYmplY3Qoe1xyXG4gICAgICAgICAgLi4uKGRhdGFTb3VyY2VFbmFibGVkID8geyBkYXRhU291cmNlSWQ6IHNjaGVtYS5zdHJpbmcoKSB9IDoge30pLFxyXG4gICAgICAgIH0pLFxyXG4gICAgICB9LFxyXG4gICAgfSxcclxuICAgIG1hbmFnZWRJbmRleFNlcnZpY2UucmVtb3ZlUG9saWN5XHJcbiAgKTtcclxufVxyXG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQU1BLElBQUFBLGFBQUEsR0FBQUMsT0FBQTtBQUVBLElBQUFDLFVBQUEsR0FBQUQsT0FBQTtBQVJBO0FBQ0E7QUFDQTtBQUNBOztBQU9lLFNBQUFFLFNBQVVDLFFBQXNCLEVBQUVDLE1BQWUsRUFBRUMsaUJBQTBCLEVBQUU7RUFDNUYsTUFBTTtJQUFFQztFQUFvQixDQUFDLEdBQUdILFFBQVE7RUFFeENDLE1BQU0sQ0FBQ0csR0FBRyxDQUNSO0lBQ0VDLElBQUksRUFBRUMsbUJBQVEsQ0FBQ0MsZUFBZTtJQUM5QkMsUUFBUSxFQUFFO01BQ1JDLEtBQUssRUFBRUMsb0JBQU0sQ0FBQ0MsTUFBTSxDQUFDO1FBQ25CQyxJQUFJLEVBQUVGLG9CQUFNLENBQUNHLE1BQU0sQ0FBQyxDQUFDO1FBQ3JCQyxJQUFJLEVBQUVKLG9CQUFNLENBQUNHLE1BQU0sQ0FBQyxDQUFDO1FBQ3JCRSxNQUFNLEVBQUVMLG9CQUFNLENBQUNNLE1BQU0sQ0FBQyxDQUFDO1FBQ3ZCQyxTQUFTLEVBQUVQLG9CQUFNLENBQUNNLE1BQU0sQ0FBQyxDQUFDO1FBQzFCRSxhQUFhLEVBQUVSLG9CQUFNLENBQUNNLE1BQU0sQ0FBQyxDQUFDO1FBQzlCRyxLQUFLLEVBQUVULG9CQUFNLENBQUNVLEtBQUssQ0FBQ1Ysb0JBQU0sQ0FBQ1csR0FBRyxDQUFDLENBQUMsQ0FBQztRQUNqQ0MsT0FBTyxFQUFFWixvQkFBTSxDQUFDVSxLQUFLLENBQUNWLG9CQUFNLENBQUNXLEdBQUcsQ0FBQyxDQUFDLENBQUM7UUFDbkNFLFdBQVcsRUFBRWIsb0JBQU0sQ0FBQ1UsS0FBSyxDQUFDVixvQkFBTSxDQUFDVyxHQUFHLENBQUMsQ0FBQyxDQUFDO1FBQ3ZDRyxlQUFlLEVBQUVkLG9CQUFNLENBQUNlLE9BQU8sQ0FBQyxDQUFDO1FBQ2pDLElBQUl2QixpQkFBaUIsR0FBRztVQUFFd0IsWUFBWSxFQUFFaEIsb0JBQU0sQ0FBQ00sTUFBTSxDQUFDO1FBQUUsQ0FBQyxHQUFHLENBQUMsQ0FBQztNQUNoRSxDQUFDO0lBQ0g7RUFDRixDQUFDLEVBQ0RiLG1CQUFtQixDQUFDd0IsaUJBQ3RCLENBQUM7RUFFRDFCLE1BQU0sQ0FBQ0csR0FBRyxDQUNSO0lBQ0VDLElBQUksRUFBRyxHQUFFQyxtQkFBUSxDQUFDQyxlQUFnQixPQUFNO0lBQ3hDQyxRQUFRLEVBQUU7TUFDUm9CLE1BQU0sRUFBRWxCLG9CQUFNLENBQUNDLE1BQU0sQ0FBQztRQUNwQmtCLEVBQUUsRUFBRW5CLG9CQUFNLENBQUNNLE1BQU0sQ0FBQztNQUNwQixDQUFDLENBQUM7TUFDRlAsS0FBSyxFQUFFQyxvQkFBTSxDQUFDQyxNQUFNLENBQUM7UUFDbkIsSUFBSVQsaUJBQWlCLEdBQUc7VUFBRXdCLFlBQVksRUFBRWhCLG9CQUFNLENBQUNNLE1BQU0sQ0FBQztRQUFFLENBQUMsR0FBRyxDQUFDLENBQUM7TUFDaEUsQ0FBQztJQUNIO0VBQ0YsQ0FBQyxFQUNEYixtQkFBbUIsQ0FBQzJCLGVBQ3RCLENBQUM7RUFFRDdCLE1BQU0sQ0FBQzhCLElBQUksQ0FDVDtJQUNFMUIsSUFBSSxFQUFFQyxtQkFBUSxDQUFDMEIsS0FBSztJQUNwQnhCLFFBQVEsRUFBRTtNQUNSeUIsSUFBSSxFQUFFdkIsb0JBQU0sQ0FBQ1csR0FBRyxDQUFDLENBQUM7TUFDbEJaLEtBQUssRUFBRUMsb0JBQU0sQ0FBQ0MsTUFBTSxDQUFDO1FBQ25CLElBQUlULGlCQUFpQixHQUFHO1VBQUV3QixZQUFZLEVBQUVoQixvQkFBTSxDQUFDTSxNQUFNLENBQUM7UUFBRSxDQUFDLEdBQUcsQ0FBQyxDQUFDO01BQ2hFLENBQUM7SUFDSDtFQUNGLENBQUMsRUFDRGIsbUJBQW1CLENBQUMrQix1QkFDdEIsQ0FBQztFQUVEakMsTUFBTSxDQUFDOEIsSUFBSSxDQUNUO0lBQ0UxQixJQUFJLEVBQUVDLG1CQUFRLENBQUM2QixhQUFhO0lBQzVCM0IsUUFBUSxFQUFFO01BQ1J5QixJQUFJLEVBQUV2QixvQkFBTSxDQUFDVyxHQUFHLENBQUMsQ0FBQztNQUNsQlosS0FBSyxFQUFFQyxvQkFBTSxDQUFDQyxNQUFNLENBQUM7UUFDbkIsSUFBSVQsaUJBQWlCLEdBQUc7VUFBRXdCLFlBQVksRUFBRWhCLG9CQUFNLENBQUNNLE1BQU0sQ0FBQztRQUFFLENBQUMsR0FBRyxDQUFDLENBQUM7TUFDaEUsQ0FBQztJQUNIO0VBQ0YsQ0FBQyxFQUNEYixtQkFBbUIsQ0FBQ2lDLFlBQ3RCLENBQUM7RUFFRG5DLE1BQU0sQ0FBQzhCLElBQUksQ0FDVDtJQUNFMUIsSUFBSSxFQUFFQyxtQkFBUSxDQUFDK0IsYUFBYTtJQUM1QjdCLFFBQVEsRUFBRTtNQUNSeUIsSUFBSSxFQUFFdkIsb0JBQU0sQ0FBQ1csR0FBRyxDQUFDLENBQUM7TUFDbEJaLEtBQUssRUFBRUMsb0JBQU0sQ0FBQ0MsTUFBTSxDQUFDO1FBQ25CLElBQUlULGlCQUFpQixHQUFHO1VBQUV3QixZQUFZLEVBQUVoQixvQkFBTSxDQUFDTSxNQUFNLENBQUM7UUFBRSxDQUFDLEdBQUcsQ0FBQyxDQUFDO01BQ2hFLENBQUM7SUFDSDtFQUNGLENBQUMsRUFDRGIsbUJBQW1CLENBQUNtQyxZQUN0QixDQUFDO0FBQ0g7QUFBQ0MsTUFBQSxDQUFBQyxPQUFBLEdBQUFBLE9BQUEsQ0FBQUMsT0FBQSJ9