"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _constants = require("../../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled = false) {
  const {
    indexService
  } = services;
  let getIndicesQuerySchema = {
    from: _configSchema.schema.number(),
    size: _configSchema.schema.number(),
    search: _configSchema.schema.string(),
    sortField: _configSchema.schema.string(),
    sortDirection: _configSchema.schema.string(),
    terms: _configSchema.schema.maybe(_configSchema.schema.any()),
    indices: _configSchema.schema.maybe(_configSchema.schema.any()),
    dataStreams: _configSchema.schema.maybe(_configSchema.schema.any()),
    showDataStreams: _configSchema.schema.boolean(),
    expandWildcards: _configSchema.schema.maybe(_configSchema.schema.string()),
    exactSearch: _configSchema.schema.maybe(_configSchema.schema.string())
  };
  if (dataSourceEnabled) {
    getIndicesQuerySchema = {
      ...getIndicesQuerySchema,
      dataSourceId: _configSchema.schema.string()
    };
  }
  router.get({
    path: _constants.NODE_API._INDICES,
    validate: {
      query: _configSchema.schema.object(getIndicesQuerySchema)
    }
  }, indexService.getIndices);
  router.post({
    path: _constants.NODE_API.APPLY_POLICY,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, indexService.applyPolicy);
  router.post({
    path: _constants.NODE_API.EDIT_ROLLOVER_ALIAS,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, indexService.editRolloverAlias);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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